/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.specification;

import com.google.common.collect.Multimap;
import java.util.Objects;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.platform.runtime.runtime.extension.RuntimeDevRuntimeExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RuntimeDevRuntimeSpecification
extends CommonRuntimeSpecification {
    private final NeoFormRuntimeDefinition neoFormRuntime;
    private final Directory patchesDirectory;
    private final Directory rejectsDirectory;
    private final boolean isUpdating;
    private final String parchmentArtifact;

    public RuntimeDevRuntimeSpecification(NeoFormRuntimeDefinition neoFormRuntime, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, Directory patchesDirectory, Directory rejectsDirectory, boolean isUpdating, String parchmentArtifact) {
        super(((NeoFormRuntimeSpecification)neoFormRuntime.getSpecification()).getProject(), "platform", ((NeoFormRuntimeSpecification)neoFormRuntime.getSpecification()).getVersion(), ((NeoFormRuntimeSpecification)neoFormRuntime.getSpecification()).getDistribution(), preTaskTypeAdapters, postTypeAdapters, taskCustomizers, RuntimeDevRuntimeExtension.class);
        this.neoFormRuntime = neoFormRuntime;
        this.patchesDirectory = patchesDirectory;
        this.rejectsDirectory = rejectsDirectory;
        this.isUpdating = isUpdating;
        this.parchmentArtifact = parchmentArtifact;
    }

    public NeoFormRuntimeDefinition getNeoFormRuntime() {
        return this.neoFormRuntime;
    }

    @NotNull
    public String getMinecraftVersion() {
        return ((NeoFormRuntimeSpecification)this.neoFormRuntime.getSpecification()).getMinecraftVersion();
    }

    public Directory getPatchesDirectory() {
        if (!this.patchesDirectory.getAsFile().exists()) {
            this.patchesDirectory.getAsFile().mkdirs();
        }
        return this.patchesDirectory;
    }

    public Directory getRejectsDirectory() {
        if (!this.rejectsDirectory.getAsFile().exists()) {
            this.rejectsDirectory.getAsFile().mkdirs();
        }
        return this.rejectsDirectory;
    }

    @Nullable
    public String getParchmentArtifact() {
        return this.parchmentArtifact;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeDevRuntimeSpecification that = (RuntimeDevRuntimeSpecification)((Object)o);
        return this.isUpdating == that.isUpdating && Objects.equals(this.neoFormRuntime, that.neoFormRuntime) && Objects.equals(this.patchesDirectory, that.patchesDirectory) && Objects.equals(this.rejectsDirectory, that.rejectsDirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.neoFormRuntime, this.patchesDirectory, this.rejectsDirectory, this.isUpdating);
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<RuntimeDevRuntimeSpecification, Builder> {
        private NeoFormRuntimeDefinition neoFormRuntimeDefinition;
        private Provider<Directory> patchesDirectory;
        private Provider<Directory> rejectsDirectory;
        private Provider<Boolean> isUpdating;
        private Provider<String> parchment;

        private Builder(Project project) {
            super(project);
            this.patchesDirectory = project.provider(() -> project.getLayout().getProjectDirectory().dir("patches"));
            this.rejectsDirectory = project.provider(() -> project.getLayout().getProjectDirectory().dir("rejects"));
            this.isUpdating = project.provider(() -> false);
        }

        protected Builder getThis() {
            return this;
        }

        public static Builder from(Project project) {
            return new Builder(project);
        }

        public Builder withNeoFormRuntime(NeoFormRuntimeDefinition neoFormRuntimeDefinition) {
            this.neoFormRuntimeDefinition = neoFormRuntimeDefinition;
            return this.getThis();
        }

        public Builder withPatchesDirectory(Provider<Directory> patchesDirectory) {
            this.patchesDirectory = patchesDirectory;
            return this.getThis();
        }

        public Builder withPatchesDirectory(Directory patchesDirectory) {
            if (patchesDirectory == null) {
                return this.getThis();
            }
            return this.withPatchesDirectory((Provider<Directory>)this.project.provider(() -> patchesDirectory));
        }

        public Builder withRejectsDirectory(Provider<Directory> rejectsDirectory) {
            this.rejectsDirectory = rejectsDirectory;
            return this.getThis();
        }

        public Builder withRejectsDirectory(Directory rejectsDirectory) {
            if (rejectsDirectory == null) {
                return this.getThis();
            }
            return this.withRejectsDirectory((Provider<Directory>)this.project.provider(() -> rejectsDirectory));
        }

        public Builder isUpdating(Provider<Boolean> isUpdating) {
            this.isUpdating = isUpdating;
            return this.getThis();
        }

        public Builder isUpdating(Boolean isUpdating) {
            if (isUpdating == null) {
                return this.getThis();
            }
            return this.isUpdating((Provider<Boolean>)this.project.provider(() -> isUpdating));
        }

        public Builder withParchment(Provider<String> parchment) {
            this.parchment = parchment;
            return this.getThis();
        }

        @NotNull
        public RuntimeDevRuntimeSpecification build() {
            if (this.neoFormRuntimeDefinition == null) {
                throw new IllegalStateException("Setting a neoFormRuntimeDefinition is required");
            }
            NeoFormRuntimeSpecification neoFormSpec = (NeoFormRuntimeSpecification)this.neoFormRuntimeDefinition.getSpecification();
            if (neoFormSpec.getProject() != this.getProject()) {
                throw new IllegalStateException("Cannot use a neoFormRuntimeDefinition from a different project (" + neoFormSpec.getProject() + ")");
            }
            if (this.distributionType.get() != neoFormSpec.getDistribution()) {
                throw new IllegalStateException("Cannot change the distribution type to " + this.distributionType.get() + " if the NeoForm runtime is for " + neoFormSpec.getDistribution());
            }
            return new RuntimeDevRuntimeSpecification(this.neoFormRuntimeDefinition, (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, (Multimap<String, TaskCustomizer<? extends Task>>)this.taskCustomizers, (Directory)this.patchesDirectory.get(), (Directory)this.rejectsDirectory.get(), (Boolean)this.isUpdating.get(), (String)this.parchment.getOrNull());
        }
    }
}

