/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.extension;

import io.codechicken.diffpatch.util.PatchMode;
import java.io.File;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.ArtifactProvider;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.ExecuteSpecification;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.platform.runtime.runtime.definition.RuntimeDevRuntimeDefinition;
import net.neoforged.gradle.platform.runtime.runtime.specification.RuntimeDevRuntimeSpecification;
import net.neoforged.gradle.platform.runtime.runtime.tasks.ApplyPatches;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeDevRuntimeExtension
extends CommonRuntimeExtension<RuntimeDevRuntimeSpecification, RuntimeDevRuntimeSpecification.Builder, RuntimeDevRuntimeDefinition> {
    @Inject
    public RuntimeDevRuntimeExtension(Project project) {
        super(project);
    }

    @NotNull
    protected RuntimeDevRuntimeDefinition doCreate(RuntimeDevRuntimeSpecification spec) {
        File workingDirectory = ((Directory)spec.getProject().getLayout().getBuildDirectory().dir(String.format("platform/%s", spec.getIdentifier())).get()).getAsFile();
        NeoFormRuntimeDefinition neoformRuntime = spec.getNeoFormRuntime();
        TaskProvider<DefaultExecute> patchBase = spec.getParchmentArtifact() != null ? RuntimeDevRuntimeExtension.applyParchment(spec.getProject(), "applyParchment", (Provider<File>)this.getProject().provider(() -> ToolUtilities.resolveTool((Project)this.getProject(), (String)spec.getParchmentArtifact())), (Provider<String>)this.getProject().provider(() -> "p_"), (Provider<File>)neoformRuntime.getSourceJarTask().flatMap(OutputSpecification::getOutput).map(RegularFile::getAsFile), true, spec, workingDirectory, null) : neoformRuntime.getSourceJarTask();
        TaskProvider patchApply = spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)"applyPatches"), ApplyPatches.class, arg_0 -> RuntimeDevRuntimeExtension.lambda$doCreate$2((TaskProvider)patchBase, spec, workingDirectory, arg_0));
        TaskProvider sourcesProvider = spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)"sourceFromAppliedPatches"), ArtifactProvider.class, task -> {
            task.getInputFiles().from(new Object[]{patchApply.flatMap(OutputSpecification::getOutput)});
            task.getOutput().set(new File(workingDirectory, "patched.jar"));
        });
        return new RuntimeDevRuntimeDefinition(spec, neoformRuntime, (TaskProvider<? extends ArtifactProvider>)sourcesProvider, patchBase);
    }

    protected RuntimeDevRuntimeSpecification.Builder createBuilder() {
        return RuntimeDevRuntimeSpecification.Builder.from(this.getProject());
    }

    public static TaskProvider<DefaultExecute> applyParchment(Project project, String name, Provider<File> mappingsFile, Provider<String> conflictPrefix, Provider<File> input, boolean inputFile, CommonRuntimeSpecification spec, File workingDirectory, @Nullable TaskProvider<? extends WithOutput> extraClasspath) {
        return project.getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)name), DefaultExecute.class, task -> {
            File toolExecutable = ToolUtilities.resolveTool((Project)project, (String)((String)((Subsystems)project.getExtensions().getByType(Subsystems.class)).getTools().getJST().get()));
            task.getArguments().putFile("mappings", mappingsFile);
            if (inputFile) {
                task.getArguments().putFile("input", input);
            } else {
                task.getArguments().putDirectoryFile("input", input);
            }
            task.getExecutingJar().set(toolExecutable);
            task.getProgramArguments().add((Object)"--enable-parchment");
            task.getProgramArguments().add((Object)"--no-parchment-javadoc");
            task.getProgramArguments().add((Object)"--parchment-mappings");
            task.getProgramArguments().add((Object)"{mappings}");
            task.getProgramArguments().add((Object)("--in-format=" + (inputFile ? "archive" : "folder")));
            task.getProgramArguments().add((Object)"--out-format=archive");
            if (conflictPrefix.isPresent() && !((String)conflictPrefix.get()).isBlank()) {
                task.getProgramArguments().add((Object)"--parchment-conflict-prefix=%s".formatted(conflictPrefix.get()));
            }
            StringBuilder builder = new StringBuilder();
            ((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getCompileClasspath().forEach(f -> {
                if (!builder.isEmpty()) {
                    builder.append(File.pathSeparator);
                }
                builder.append(f.getAbsolutePath());
            });
            if (extraClasspath != null) {
                builder.append(File.pathSeparator).append(((RegularFile)((WithOutput)extraClasspath.get()).getOutput().get()).getAsFile().getAbsolutePath());
                task.dependsOn(new Object[]{extraClasspath});
            }
            task.getProgramArguments().add((Object)("--classpath=" + builder));
            task.getLogLevel().set((Object)ExecuteSpecification.LogLevel.DISABLED);
            task.getProgramArguments().add((Object)"{input}");
            task.getProgramArguments().add((Object)"{output}");
            CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (String)name, (CommonRuntimeSpecification)spec, (File)workingDirectory);
        });
    }

    private static /* synthetic */ void lambda$doCreate$2(TaskProvider patchBase, RuntimeDevRuntimeSpecification spec, File workingDirectory, ApplyPatches task) {
        task.getBase().set(patchBase.flatMap(OutputSpecification::getOutput));
        task.getPatches().set((Object)spec.getPatchesDirectory());
        task.getRejects().set((Object)spec.getRejectsDirectory());
        task.getPatchMode().set((Object)(spec.isUpdating() ? PatchMode.FUZZY : PatchMode.ACCESS));
        task.getShouldFailOnPatchFailure().set((Object)(!spec.isUpdating() ? 1 : 0));
        RuntimeDevRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (String)"applyPatches", (CommonRuntimeSpecification)spec, (File)workingDirectory);
    }
}

