/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.extensions;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.platform.extensions.LibraryManager;
import net.neoforged.gradle.dsl.platform.model.Library;
import net.neoforged.gradle.dsl.platform.util.LibraryCollector;
import net.neoforged.gradle.util.ModuleDependencyUtils;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;

public abstract class LibraryManagerImpl
implements LibraryManager {
    private final Map<String, Provider<Set<String>>> classpathMap = new ConcurrentHashMap<String, Provider<Set<String>>>();
    private final Map<String, Provider<Set<Library>>> libraryMap = new ConcurrentHashMap<String, Provider<Set<Library>>>();
    private final Project project;

    @Inject
    public LibraryManagerImpl(Project project) {
        this.project = project;
    }

    public Provider<Set<String>> getClasspathOf(Provider<String> library) {
        return library.flatMap(lib -> this.classpathMap.computeIfAbsent((String)lib, key -> {
            NamedDomainObjectProvider<Configuration> configuration = this.getOrCreateConfigurationForTool(this.project, (String)key);
            return LibraryManagerImpl.gatherLibraryIdsFromConfiguration(this.project, configuration);
        }));
    }

    public Provider<Set<Library>> getLibrariesOf(Provider<String> library) {
        return library.flatMap(lib -> this.libraryMap.computeIfAbsent((String)lib, key -> {
            NamedDomainObjectProvider<Configuration> configuration = this.getOrCreateConfigurationForTool(this.project, (String)key);
            return LibraryManagerImpl.gatherLibrariesFromConfiguration(this.project, configuration);
        }));
    }

    public Provider<Set<String>> getClasspathOf(String library) {
        return this.classpathMap.computeIfAbsent(library, key -> {
            NamedDomainObjectProvider<Configuration> configuration = this.getOrCreateConfigurationForTool(this.project, (String)key);
            return LibraryManagerImpl.gatherLibraryIdsFromConfiguration(this.project, configuration);
        });
    }

    public Provider<Set<Library>> getLibrariesOf(String library) {
        return this.libraryMap.computeIfAbsent(library, key -> {
            NamedDomainObjectProvider<Configuration> configuration = this.getOrCreateConfigurationForTool(this.project, (String)key);
            return LibraryManagerImpl.gatherLibrariesFromConfiguration(this.project, configuration);
        });
    }

    private static Provider<Set<Library>> gatherLibrariesFromConfiguration(Project project, Provider<Configuration> configurationProvider) {
        List repositoryUrls = project.getRepositories().withType(MavenArtifactRepository.class).stream().map(MavenArtifactRepository::getUrl).collect(Collectors.toList());
        Logger logger = project.getLogger();
        ObjectFactory objectFactory = project.getObjects();
        SetProperty property = objectFactory.setProperty(Library.class);
        property.set(configurationProvider.flatMap(config -> {
            logger.info("Finding download URLs for configuration ${config.name}");
            return config.getIncoming().getArtifacts().getResolvedArtifacts().map(artifacts -> {
                LibraryCollector libraryCollector = new LibraryCollector(objectFactory, repositoryUrls, logger);
                for (ResolvedArtifactResult resolvedArtifact : artifacts) {
                    libraryCollector.visit(resolvedArtifact);
                }
                return libraryCollector.getLibraries();
            });
        }));
        property.finalizeValueOnRead();
        property.disallowChanges();
        return property;
    }

    private static Provider<Set<String>> gatherLibraryIdsFromConfiguration(Project project, Provider<Configuration> configurationProvider) {
        SetProperty property = project.getObjects().setProperty(String.class);
        Logger logger = project.getLogger();
        property.set(configurationProvider.flatMap(config -> config.getIncoming().getArtifacts().getResolvedArtifacts().map(artifacts -> artifacts.stream().map(it -> {
            ComponentIdentifier componentId = it.getId().getComponentIdentifier();
            if (componentId instanceof ModuleComponentIdentifier) {
                ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)componentId;
                String group = moduleComponentIdentifier.getGroup();
                String module = moduleComponentIdentifier.getModule();
                Object version = moduleComponentIdentifier.getVersion();
                String classifier = LibraryCollector.guessMavenClassifier((File)it.getFile(), (ModuleComponentIdentifier)moduleComponentIdentifier);
                String extension = FilenameUtils.getExtension((String)it.getFile().getName());
                if (classifier != "") {
                    version = (String)version + ":" + classifier;
                }
                return "%s:%s:%s@%s".formatted(group, module, version, extension);
            }
            logger.warn("Cannot handle component: {}", (Object)componentId);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet()))));
        property.finalizeValueOnRead();
        property.disallowChanges();
        return property;
    }

    private NamedDomainObjectProvider<Configuration> getOrCreateConfigurationForTool(Project project, String tool) {
        String configName = "neoForgeInstallerTool" + ModuleDependencyUtils.toConfigurationName((String)tool);
        try {
            return project.getConfigurations().named(configName);
        }
        catch (UnknownDomainObjectException ignored) {
            return project.getConfigurations().register(configName, spec -> {
                spec.setCanBeConsumed(false);
                spec.setCanBeResolved(true);
                spec.getDependencies().add((Object)project.getDependencies().create((Object)tool));
            });
        }
    }
}

