/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.minecraftforge.gdi.BaseDSLElement;
import net.minecraftforge.gdi.annotations.DSLProperty;
import net.minecraftforge.gdi.annotations.ProjectGetter;
import net.minecraftforge.srgutils.IMappingFile;
import net.neoforged.gradle.common.dependency.ExtraJarDependencyManager;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.JarJarExtension;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.tasks.JarJar;
import net.neoforged.gradle.common.tasks.PotentiallySignJar;
import net.neoforged.gradle.common.tasks.WriteIMappingsFile;
import net.neoforged.gradle.common.util.CacheableIMappingFile;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.naming.ApplyMappingsToCompiledJarTaskBuilder;
import net.neoforged.gradle.dsl.common.runtime.naming.TaskBuildingContext;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.Artifact;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.dsl.platform.model.InstallerProfile;
import net.neoforged.gradle.dsl.platform.model.LauncherProfile;
import net.neoforged.gradle.dsl.platform.model.Library;
import net.neoforged.gradle.dsl.platform.util.RepositoryCollection;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.neoform.NeoFormProjectPlugin;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.runtime.tasks.Download;
import net.neoforged.gradle.neoform.runtime.tasks.PackJar;
import net.neoforged.gradle.neoform.runtime.tasks.UnpackZip;
import net.neoforged.gradle.neoform.util.NeoFormRuntimeUtils;
import net.neoforged.gradle.platform.PlatformDevProjectPlugin;
import net.neoforged.gradle.platform.model.DynamicProjectType;
import net.neoforged.gradle.platform.runtime.runtime.definition.RuntimeDevRuntimeDefinition;
import net.neoforged.gradle.platform.runtime.runtime.extension.RuntimeDevRuntimeExtension;
import net.neoforged.gradle.platform.runtime.runtime.specification.RuntimeDevRuntimeSpecification;
import net.neoforged.gradle.platform.runtime.runtime.tasks.GenerateBinaryPatches;
import net.neoforged.gradle.platform.runtime.runtime.tasks.GenerateSourcePatches;
import net.neoforged.gradle.platform.tasks.BakePatches;
import net.neoforged.gradle.platform.tasks.CreateClasspathFiles;
import net.neoforged.gradle.platform.tasks.CreateLauncherJson;
import net.neoforged.gradle.platform.tasks.CreateLegacyInstaller;
import net.neoforged.gradle.platform.tasks.CreateLegacyInstallerJson;
import net.neoforged.gradle.platform.tasks.CreateUserdevJson;
import net.neoforged.gradle.platform.tasks.OfficialMappingsJustParameters;
import net.neoforged.gradle.platform.tasks.SetupProjectFromRuntime;
import net.neoforged.gradle.platform.tasks.StripBinPatchedClasses;
import net.neoforged.gradle.platform.tasks.TokenizedTask;
import net.neoforged.gradle.platform.util.ArtifactPathsCollector;
import net.neoforged.gradle.platform.util.SetupUtils;
import net.neoforged.gradle.util.TransformerUtils;
import net.neoforged.gradle.vanilla.VanillaProjectPlugin;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.extensions.VanillaRuntimeExtension;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicProjectExtension
implements BaseDSLElement<DynamicProjectExtension> {
    private final Project project;
    @Nullable
    private DynamicProjectType type = null;

    @Inject
    public DynamicProjectExtension(Project project) {
        this.project = project;
        this.getIsUpdating().convention(this.getProviderFactory().gradleProperty("updating").map(Boolean::valueOf).orElse((Object)false));
        project.getPlugins().apply("java-library");
    }

    @ProjectGetter
    public Project getProject() {
        return this.project;
    }

    public void clean() {
        this.clean("+");
    }

    public void clean(String minecraftVersion) {
        this.type = DynamicProjectType.CLEAN;
        this.project.getPlugins().apply(VanillaProjectPlugin.class);
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class);
        SourceSet mainSource = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        VanillaRuntimeExtension vanillaRuntimeExtension = (VanillaRuntimeExtension)this.project.getExtensions().getByType(VanillaRuntimeExtension.class);
        VanillaRuntimeDefinition runtimeDefinition = (VanillaRuntimeDefinition)vanillaRuntimeExtension.create(builder -> builder.withMinecraftVersion(minecraftVersion).withDistributionType(DistributionType.CLIENT));
        this.project.getTasks().named(mainSource.getCompileJavaTaskName()).configure(task -> task.setEnabled(false));
        this.configureSetupTasks((Provider<RegularFile>)runtimeDefinition.getSourceJarTask().flatMap(OutputSpecification::getOutput), mainSource, runtimeDefinition.getMinecraftDependenciesConfiguration());
    }

    public void neoform() {
        this.neoform("+");
    }

    public void neoform(String neoFormVersion) {
        this.type = DynamicProjectType.NEO_FORM;
        this.project.getPlugins().apply(NeoFormProjectPlugin.class);
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class);
        SourceSet mainSource = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        NeoFormRuntimeExtension neoFormRuntimeExtension = (NeoFormRuntimeExtension)this.project.getExtensions().getByType(NeoFormRuntimeExtension.class);
        NeoFormRuntimeDefinition runtimeDefinition = (NeoFormRuntimeDefinition)neoFormRuntimeExtension.create(builder -> {
            builder.withNeoFormVersion(neoFormVersion).withDistributionType(DistributionType.JOINED);
            NeoFormRuntimeUtils.configureDefaultRuntimeSpecBuilder((Project)this.project, (NeoFormRuntimeSpecification.Builder)builder);
        });
        Provider parchmentArtifact = this.getParchment().map(parch -> {
            String[] split = parch.split("-");
            return "org.parchmentmc.data:parchment-" + split[0] + ":" + split[1] + "@zip";
        });
        TaskProvider<DefaultExecute> sourcesTask = runtimeDefinition.getSourceJarTask();
        if (parchmentArtifact.isPresent()) {
            sourcesTask = RuntimeDevRuntimeExtension.applyParchment(this.getProject(), "applyParchment", (Provider<File>)this.getProject().provider(() -> ToolUtilities.resolveTool((Project)this.getProject(), (String)((String)parchmentArtifact.get()))), (Provider<String>)this.getProject().provider(() -> "p_"), (Provider<File>)sourcesTask.flatMap(OutputSpecification::getOutput).map(RegularFile::getAsFile), true, runtimeDefinition.getSpecification(), ((Directory)this.project.getLayout().getBuildDirectory().dir(String.format("neoForm/%s", neoFormVersion)).get()).getAsFile(), null);
        }
        this.configureSetupTasks((Provider<RegularFile>)sourcesTask.flatMap(OutputSpecification::getOutput), mainSource, runtimeDefinition.getMinecraftDependenciesConfiguration());
    }

    public void runtime(String neoFormVersion) {
        this.runtime(neoFormVersion, this.project.getRootProject().getLayout().getProjectDirectory().dir("patches"), this.project.getRootProject().getLayout().getProjectDirectory().dir("rejects"));
    }

    public void runtime(String neoFormVersion, Directory patches, Directory rejects) {
        this.type = DynamicProjectType.RUNTIME;
        this.project.getPlugins().apply(PlatformDevProjectPlugin.class);
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class);
        SourceSet mainSource = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        NeoFormRuntimeExtension neoFormRuntimeExtension = (NeoFormRuntimeExtension)this.getProject().getExtensions().getByType(NeoFormRuntimeExtension.class);
        NeoFormRuntimeDefinition neoFormRuntimeDefinition = (NeoFormRuntimeDefinition)neoFormRuntimeExtension.create(builder -> {
            builder.withNeoFormVersion(neoFormVersion).withDistributionType(DistributionType.JOINED);
            NeoFormRuntimeUtils.configureDefaultRuntimeSpecBuilder((Project)this.project, (NeoFormRuntimeSpecification.Builder)builder);
        });
        String neoformDependency = "net.neoforged:neoform:" + ((NeoFormRuntimeSpecification)neoFormRuntimeDefinition.getSpecification()).getVersion() + "@zip";
        Provider parchmentArtifact = this.getParchment().map(parch -> {
            String[] split = parch.split("-");
            return "org.parchmentmc.data:parchment-" + split[0] + ":" + split[1] + "@zip";
        });
        RuntimeDevRuntimeExtension runtimeDevRuntimeExtension = (RuntimeDevRuntimeExtension)((Object)this.project.getExtensions().getByType(RuntimeDevRuntimeExtension.class));
        RuntimeDevRuntimeDefinition runtimeDefinition = (RuntimeDevRuntimeDefinition)runtimeDevRuntimeExtension.create(builder -> ((RuntimeDevRuntimeSpecification.Builder)builder.withNeoFormRuntime(neoFormRuntimeDefinition).withPatchesDirectory(patches).withRejectsDirectory(rejects).withDistributionType(DistributionType.JOINED)).withParchment((Provider<String>)parchmentArtifact).isUpdating((Provider<Boolean>)this.getIsUpdating()));
        this.project.getExtensions().add("runtime", (Object)runtimeDefinition);
        IdeManagementExtension ideManagementExtension = (IdeManagementExtension)this.project.getExtensions().getByType(IdeManagementExtension.class);
        ideManagementExtension.registerTaskToRun(runtimeDefinition.getAssets());
        ideManagementExtension.registerTaskToRun(runtimeDefinition.getNatives());
        File workingDirectory = ((Directory)this.getProject().getLayout().getBuildDirectory().dir(String.format("platform/%s", ((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getIdentifier())).get()).getAsFile();
        Configuration clientExtraConfiguration = (Configuration)this.project.getConfigurations().create("clientExtra");
        Configuration serverExtraConfiguration = (Configuration)this.project.getConfigurations().create("serverExtra");
        Configuration installerConfiguration = (Configuration)this.project.getConfigurations().create("installer");
        Configuration installerLibrariesConfiguration = (Configuration)this.project.getConfigurations().create("installerLibraries");
        Configuration moduleOnlyConfiguration = ((Configuration)this.project.getConfigurations().create("moduleOnly")).setTransitive(false);
        Configuration gameLayerLibraryConfiguration = ((Configuration)this.project.getConfigurations().create("gameLayerLibrary")).setTransitive(false);
        Configuration pluginLayerLibraryConfiguration = ((Configuration)this.project.getConfigurations().create("pluginLayerLibrary")).setTransitive(false);
        Configuration userdevCompileOnlyConfiguration = ((Configuration)this.project.getConfigurations().create("userdevCompileOnly")).setTransitive(false);
        Configuration userdevTestImplementationConfiguration = ((Configuration)this.project.getConfigurations().create("userdevTestImplementation")).setTransitive(true);
        Configuration jarJarConfiguration = (Configuration)this.project.getConfigurations().create("jarJar");
        clientExtraConfiguration.getDependencies().add((Object)this.project.getDependencies().create((Object)ExtraJarDependencyManager.generateClientCoordinateFor((String)((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion())));
        serverExtraConfiguration.getDependencies().add((Object)this.project.getDependencies().create((Object)ExtraJarDependencyManager.generateServerCoordinateFor((String)((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion())));
        installerLibrariesConfiguration.extendsFrom(new Configuration[]{installerConfiguration});
        installerLibrariesConfiguration.getDependencies().add((Object)this.project.getDependencyFactory().create((CharSequence)neoformDependency));
        this.project.getConfigurations().getByName(mainSource.getApiConfigurationName()).extendsFrom(new Configuration[]{gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, installerConfiguration});
        this.project.getConfigurations().getByName(mainSource.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{clientExtraConfiguration});
        this.project.getExtensions().configure(RunTypeManager.class, types -> types.configureEach(type -> this.configureRunType(this.project, (RunType)type, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, runtimeDefinition)));
        this.project.getExtensions().configure(RunManager.class, runs -> runs.configureAll(run -> this.configureRun((Run)run, runtimeDefinition)));
        this.project.getExtensions().create(net.neoforged.gradle.dsl.common.extensions.JarJar.class, "jarJar", JarJarExtension.class, new Object[]{this.project});
        LauncherProfile launcherProfile = (LauncherProfile)this.project.getExtensions().create(LauncherProfile.class, "launcherProfile", LauncherProfile.class, new Object[0]);
        InstallerProfile installerProfile = (InstallerProfile)this.project.getExtensions().create("installerProfile", InstallerProfile.class, new Object[0]);
        UserdevProfile userdevProfile = (UserdevProfile)this.project.getExtensions().create("userdevProfile", UserdevProfile.class, new Object[]{this.project.getObjects()});
        TaskProvider<SetupProjectFromRuntime> setupTask = this.configureSetupTasks((Provider<RegularFile>)runtimeDefinition.getSourceJarTask().flatMap(OutputSpecification::getOutput), mainSource, runtimeDefinition.getMinecraftDependenciesConfiguration());
        setupTask.configure(task -> task.getShouldLockDirectories().set((Object)false));
        this.project.afterEvaluate(evaledProject -> {
            TaskProvider bakePatches;
            Provider<RegularFile> compiledJarProvider;
            EnumMap<DistributionType, Object> cleanProviders = new EnumMap<DistributionType, Object>(DistributionType.class);
            cleanProviders.put(DistributionType.CLIENT, (Object)this.createCleanProvider((TaskProvider<? extends WithOutput>)((TaskProvider)runtimeDefinition.getGameArtifactProvidingTasks().get(GameArtifact.CLIENT_JAR)), runtimeDefinition, workingDirectory));
            cleanProviders.put(DistributionType.SERVER, (Object)this.createCleanProvider((TaskProvider<? extends WithOutput>)runtimeDefinition.getJoinedNeoFormRuntimeDefinition().getTask("extractServer"), runtimeDefinition, workingDirectory));
            cleanProviders.put(DistributionType.JOINED, (Object)runtimeDefinition.getJoinedNeoFormRuntimeDefinition().getTask("rename"));
            EnumMap<DistributionType, TaskProvider<? extends WithOutput>> obfToMojMappingProviders = new EnumMap<DistributionType, TaskProvider<? extends WithOutput>>(DistributionType.class);
            TaskProvider<? extends WithOutput> clientInverseMappings = this.createFlippedMojMapProvider((TaskProvider<? extends WithOutput>)((TaskProvider)runtimeDefinition.getGameArtifactProvidingTasks().get(GameArtifact.CLIENT_MAPPINGS)), runtimeDefinition, workingDirectory);
            TaskProvider<? extends WithOutput> serverInverseMappings = this.createFlippedMojMapProvider((TaskProvider<? extends WithOutput>)((TaskProvider)runtimeDefinition.getGameArtifactProvidingTasks().get(GameArtifact.SERVER_MAPPINGS)), runtimeDefinition, workingDirectory);
            obfToMojMappingProviders.put(DistributionType.CLIENT, clientInverseMappings);
            obfToMojMappingProviders.put(DistributionType.SERVER, serverInverseMappings);
            obfToMojMappingProviders.put(DistributionType.JOINED, clientInverseMappings);
            TaskProvider neoFormSources = runtimeDefinition.getJoinedNeoFormRuntimeDefinition().getSourceJarTask();
            TaskProvider packChanges = this.project.getTasks().register("packForgeChanges", PackJar.class, task -> {
                task.getInputFiles().from(new Object[]{SetupUtils.getSetupSourceTarget(this.getProject())});
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider createPatches = this.project.getTasks().register("createSourcePatches", GenerateSourcePatches.class, task -> {
                task.getBase().set(runtimeDefinition.getPatchBase().flatMap(OutputSpecification::getOutput));
                task.getModified().set(packChanges.flatMap(OutputSpecification::getOutput));
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider unpackZip = this.project.getTasks().register("unpackSourcePatches", UnpackZip.class, task -> {
                task.getInput().from(new Object[]{this.project.zipTree((Object)createPatches.flatMap(OutputSpecification::getOutput))});
                task.getUnpackingTarget().set((Object)patches);
                task.dependsOn(new Object[]{createPatches});
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider mergeMappings = runtimeDefinition.getJoinedNeoFormRuntimeDefinition().getTask("mergeMappings");
            if (parchmentArtifact.isPresent()) {
                TaskProvider officialWithParams = this.project.getTasks().register(CommonRuntimeUtils.buildTaskName((Definition)runtimeDefinition, (String)"officialMappingsJustParameters"), OfficialMappingsJustParameters.class, tsk -> {
                    tsk.getInput().set(mergeMappings.flatMap(OutputSpecification::getOutput));
                    tsk.dependsOn(new Object[]{mergeMappings});
                    CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)tsk, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
                });
                compiledJarProvider = this.renameCompiledJar((TaskProvider<? extends WithOutput>)officialWithParams, (TaskProvider<? extends Jar>)this.project.getTasks().named(mainSource.getJarTaskName(), Jar.class), runtimeDefinition, workingDirectory);
            } else {
                compiledJarProvider = this.project.getTasks().named(mainSource.getJarTaskName(), Jar.class).flatMap(AbstractArchiveTask::getArchiveFile);
            }
            javaPluginExtension.withSourcesJar();
            TaskProvider sourcesJarProvider = this.project.getTasks().named(mainSource.getSourcesJarTaskName(), Jar.class);
            sourcesJarProvider.configure(task -> {
                task.exclude(new String[]{"net/minecraft/**"});
                task.exclude(new String[]{"com/**"});
                task.exclude(new String[]{"mcp/**"});
            });
            EnumMap<DistributionType, TaskProvider> binaryPatchGenerators = new EnumMap<DistributionType, TaskProvider>(DistributionType.class);
            for (DistributionType distribution : DistributionType.values()) {
                TaskProvider cleanProvider = (TaskProvider)cleanProviders.get(distribution);
                TaskProvider generateBinaryPatchesTask = this.project.getTasks().register(distribution.createTaskName("generate", "BinaryPatches"), GenerateBinaryPatches.class, task -> {
                    task.getClean().set(cleanProvider.flatMap(OutputSpecification::getOutput));
                    task.getPatched().set(compiledJarProvider);
                    task.getDistributionType().set((Object)distribution);
                    task.getPatches().from(new Object[]{patches});
                    task.getMappings().set(((TaskProvider)obfToMojMappingProviders.get(distribution)).flatMap(OutputSpecification::getOutput));
                    task.mustRunAfter(new Object[]{unpackZip});
                    task.mustRunAfter(new Object[]{setupTask});
                    CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
                });
                binaryPatchGenerators.put(distribution, generateBinaryPatchesTask);
            }
            Configuration runtimeClasspath = this.project.getConfigurations().getByName(((SourceSet)((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).findByName("main")).getRuntimeClasspathConfigurationName());
            launcherProfile.configure(profile -> {
                profile.getId().set((Object)String.format("%s-%s", this.project.getName(), this.project.getVersion()));
                profile.getTime().set((Object)LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
                profile.getReleaseTime().set((Provider)profile.getTime());
                profile.getType().set((Object)"release");
                profile.getMainClass().set((Object)"cpw.mods.bootstraplauncher.BootstrapLauncher");
                profile.getInheritsFrom().set((Object)((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion());
                profile.getLoggingConfiguration().set((Object)((LauncherProfile.LoggingConfiguration)this.project.getObjects().newInstance(LauncherProfile.LoggingConfiguration.class, new Object[0])));
                LauncherProfile.Arguments arguments = (LauncherProfile.Arguments)launcherProfile.getArguments().get();
                arguments.game("--launchTarget");
                arguments.game("forgeclient");
                arguments.jvm("-Djava.net.preferIPv6Addresses=system");
                arguments.jvm(DynamicProjectExtension.createIgnoreList(this.project, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration).map(ignoreList -> "-DignoreList=" + ignoreList + ",${version_name}.jar"));
                arguments.jvm("-DmergeModules=jna-5.10.0.jar,jna-platform-5.10.0.jar");
                arguments.jvm(DynamicProjectExtension.collectFileNames(pluginLayerLibraryConfiguration, this.project).map(pluginLayerLibraries -> "-Dfml.pluginLayerLibraries=" + pluginLayerLibraries));
                arguments.jvm(DynamicProjectExtension.collectFileNames(gameLayerLibraryConfiguration, this.project).map(gameLayerLibraries -> "-Dfml.gameLayerLibraries=" + gameLayerLibraries));
                arguments.jvm("-DlibraryDirectory=${library_directory}");
                arguments.jvm("-p");
                arguments.jvm(DynamicProjectExtension.collectFilePaths(moduleOnlyConfiguration, "${library_directory}/", "${classpath_separator}", this.project));
                arguments.jvm("--add-modules");
                arguments.jvm("ALL-MODULE-PATH");
                arguments.jvm("--add-opens");
                arguments.jvm("java.base/java.util.jar=cpw.mods.securejarhandler");
                arguments.jvm("--add-opens");
                arguments.jvm("java.base/java.lang.invoke=cpw.mods.securejarhandler");
                arguments.jvm("--add-exports");
                arguments.jvm("java.base/sun.security.util=cpw.mods.securejarhandler");
                arguments.jvm("--add-exports");
                arguments.jvm("jdk.naming.dns/com.sun.jndi.dns=java.naming");
                launcherProfile.getArguments().set((Object)arguments);
            });
            Configuration installerRuntimeLibrariesConfiguration = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)this.project.getConfigurations(), (String)"InstallerRuntimeLibraries", (Dependency[])new Dependency[0]);
            ConfigurationUtils.extendsFrom((Project)this.project, (Configuration)installerRuntimeLibrariesConfiguration, (Configuration[])new Configuration[]{installerConfiguration});
            installerRuntimeLibrariesConfiguration.shouldResolveConsistentlyWith(runtimeClasspath);
            ListProperty repoCollection = new RepositoryCollection(this.project.getProviders(), this.project.getObjects(), this.project.getRepositories()).getURLs();
            TaskProvider createLauncherJson = this.project.getTasks().register("createLauncherJson", CreateLauncherJson.class, task -> {
                task.getProfile().set((Object)launcherProfile);
                task.getLibraries().from(new Object[]{installerRuntimeLibrariesConfiguration});
                task.getLibraries().from(new Object[]{pluginLayerLibraryConfiguration});
                task.getLibraries().from(new Object[]{gameLayerLibraryConfiguration});
                task.getLibraries().from(new Object[]{moduleOnlyConfiguration});
                task.getRepositoryURLs().set((Provider)repoCollection);
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider joinedCleanProvider = (TaskProvider)cleanProviders.get(DistributionType.JOINED);
            TaskProvider strippedJar = this.project.getTasks().register("stripBinaryPatchedClasses", StripBinPatchedClasses.class, task -> {
                task.getCompiled().set(this.project.getTasks().named(mainSource.getJarTaskName(), Jar.class).flatMap(AbstractArchiveTask::getArchiveFile));
                task.getClean().set(joinedCleanProvider.flatMap(OutputSpecification::getOutput));
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider universalJar = this.project.getTasks().register("universalJar", JarJar.class, task -> {
                task.getArchiveClassifier().set((Object)"universal-unsigned");
                task.getArchiveAppendix().set((Object)"universal-unsigned");
                task.getArchiveVersion().set((Object)this.project.getVersion().toString());
                task.getArchiveBaseName().set((Object)this.project.getName());
                task.getDestinationDirectory().set(this.project.getLayout().getBuildDirectory().dir("libs"));
                task.getArchiveFileName().set(this.project.provider(() -> String.format("%s-%s-universal-unsigned.jar", this.project.getName(), this.project.getVersion())));
                task.dependsOn(new Object[]{strippedJar});
                task.from(new Object[]{this.project.zipTree((Object)strippedJar.flatMap(OutputSpecification::getOutput))});
                task.manifest(manifest -> {
                    manifest.attributes((Map)ImmutableMap.of((Object)"FML-System-Mods", (Object)"neoforge"));
                    manifest.attributes((Map)ImmutableMap.of((Object)"Specification-Title", (Object)"NeoForge", (Object)"Specification-Vendor", (Object)"NeoForge", (Object)"Specification-Version", (Object)this.project.getVersion().toString().substring(0, this.project.getVersion().toString().lastIndexOf(".")), (Object)"Implementation-Title", (Object)this.project.getGroup(), (Object)"Implementation-Version", (Object)this.project.getVersion(), (Object)"Implementation-Vendor", (Object)"NeoForged"), "net/neoforged/neoforge/internal/versions/neoforge/");
                    manifest.attributes((Map)ImmutableMap.of((Object)"Specification-Title", (Object)"Minecraft", (Object)"Specification-Vendor", (Object)"Mojang", (Object)"Specification-Version", (Object)((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion(), (Object)"Implementation-Title", (Object)"MCP", (Object)"Implementation-Version", (Object)((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getVersion(), (Object)"Implementation-Vendor", (Object)"NeoForged"), "net/neoforged/neoforge/versions/neoform/");
                });
                task.configuration(jarJarConfiguration);
            });
            TaskProvider signUniversalJar = this.project.getTasks().register("signUniversalJar", PotentiallySignJar.class, task -> {
                task.getInput().set(universalJar.flatMap(AbstractArchiveTask::getArchiveFile));
                task.getOutputFileName().set(this.project.provider(() -> String.format("%s-%s-universal.jar", this.project.getName(), this.project.getVersion())));
                task.dependsOn(new Object[]{universalJar});
            });
            Tools tools = ((Subsystems)this.project.getExtensions().getByType(Subsystems.class)).getTools();
            installerProfile.configure(profile -> {
                profile.getProfile().convention((Object)this.project.getName());
                profile.getVersion().set((Provider)launcherProfile.getId());
                profile.getMinecraft().set((Object)((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion());
                profile.getServerJarPath().set((Object)"{LIBRARY_DIR}/net/minecraft/server/{MINECRAFT_VERSION}/server-{MINECRAFT_VERSION}.jar");
                profile.data("MAPPINGS", String.format("[net.neoforged:neoform:%s:mappings@txt]", neoFormVersion), String.format("[net.neoforged:neoform:%s:mappings@txt]", neoFormVersion));
                profile.data("MOJMAPS", String.format("[net.minecraft:client:%s:mappings@txt]", neoFormVersion), String.format("[net.minecraft:server:%s:mappings@txt]", neoFormVersion));
                profile.data("MERGED_MAPPINGS", String.format("[net.neoforged:neoform:%s:mappings-merged@txt]", neoFormVersion), String.format("[net.neoforged:neoform:%s:mappings-merged@txt]", neoFormVersion));
                profile.data("BINPATCH", "/data/client.lzma", "/data/server.lzma");
                profile.data("MC_UNPACKED", String.format("[net.minecraft:client:%s:unpacked]", neoFormVersion), String.format("[net.minecraft:server:%s:unpacked]", neoFormVersion));
                profile.data("MC_SLIM", String.format("[net.minecraft:client:%s:slim]", neoFormVersion), String.format("[net.minecraft:server:%s:slim]", neoFormVersion));
                profile.data("MC_EXTRA", String.format("[net.minecraft:client:%s:extra]", neoFormVersion), String.format("[net.minecraft:server:%s:extra]", neoFormVersion));
                profile.data("MC_SRG", String.format("[net.minecraft:client:%s:srg]", neoFormVersion), String.format("[net.minecraft:server:%s:srg]", neoFormVersion));
                profile.data("PATCHED", String.format("[%s:%s:%s:client]", "net.neoforged", "neoforge", this.project.getVersion()), String.format("[%s:%s:%s:server]", "net.neoforged", "neoforge", this.project.getVersion()));
                profile.data("MCP_VERSION", String.format("'%s'", neoFormVersion), String.format("'%s'", neoFormVersion));
                profile.processor(this.project, Tools::getInstallerTools, processor -> {
                    processor.server();
                    processor.getArguments().addAll((Object[])new String[]{"--task", "EXTRACT_FILES", "--archive", "{INSTALLER}", "--from", "data/run.sh", "--to", "{ROOT}/run.sh", "--exec", "{ROOT}/run.sh", "--from", "data/run.bat", "--to", "{ROOT}/run.bat", "--from", "data/user_jvm_args.txt", "--to", "{ROOT}/user_jvm_args.txt", "--optional", "{ROOT}/user_jvm_args.txt", "--from", "data/win_args.txt", "--to", String.format("{ROOT}/libraries/%s/%s/%s/win_args.txt", this.project.getGroup().toString().replaceAll("\\.", "/"), this.project.getName(), this.project.getVersion()), "--from", "data/unix_args.txt", "--to", String.format("{ROOT}/libraries/%s/%s/%s/unix_args.txt", this.project.getGroup().toString().replaceAll("\\.", "/"), this.project.getName(), this.project.getVersion())});
                });
                profile.processor(this.project, Tools::getInstallerTools, processor -> {
                    processor.server();
                    processor.getArguments().addAll((Object[])new String[]{"--task", "BUNDLER_EXTRACT", "--input", "{MINECRAFT_JAR}", "--output", "{ROOT}/libraries/", "--libraries"});
                });
                profile.processor(this.project, Tools::getInstallerTools, processor -> {
                    processor.server();
                    processor.getArguments().addAll((Object[])new String[]{"--task", "BUNDLER_EXTRACT", "--input", "{MINECRAFT_JAR}", "--output", "{MC_UNPACKED}", "--jar-only"});
                });
                profile.processor(this.project, Tools::getInstallerTools, processor -> processor.getArguments().addAll((Object[])new String[]{"--task", "MCP_DATA", "--input", String.format("[%s]", neoformDependency), "--output", "{MAPPINGS}", "--key", "mappings"}));
                profile.processor(this.project, Tools::getInstallerTools, processor -> processor.getArguments().addAll((Object[])new String[]{"--task", "DOWNLOAD_MOJMAPS", "--version", ((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion(), "--side", "{SIDE}", "--output", "{MOJMAPS}"}));
                profile.processor(this.project, Tools::getInstallerTools, processor -> processor.getArguments().addAll((Object[])new String[]{"--task", "MERGE_MAPPING", "--left", "{MAPPINGS}", "--right", "{MOJMAPS}", "--output", "{MERGED_MAPPINGS}", "--classes", "--fields", "--methods", "--reverse-right"}));
                profile.processor(this.project, Tools::getJarSplitter, processor -> {
                    processor.client();
                    processor.getArguments().addAll((Object[])new String[]{"--input", "{MINECRAFT_JAR}", "--slim", "{MC_SLIM}", "--extra", "{MC_EXTRA}", "--srg", "{MERGED_MAPPINGS}"});
                });
                profile.processor(this.project, Tools::getJarSplitter, processor -> {
                    processor.server();
                    processor.getArguments().addAll((Object[])new String[]{"--input", "{MC_UNPACKED}", "--slim", "{MC_SLIM}", "--extra", "{MC_EXTRA}", "--srg", "{MERGED_MAPPINGS}"});
                });
                profile.processor(this.project, (Provider)tools.getAutoRenamingTool(), processor -> processor.getArguments().addAll((Object[])new String[]{"--input", "{MC_SLIM}", "--output", "{MC_SRG}", "--names", "{MERGED_MAPPINGS}", "--ann-fix", "--ids-fix", "--src-fix", "--record-fix"}));
                profile.processor(this.project, (Provider)tools.getBinaryPatcher(), processor -> processor.getArguments().addAll((Object[])new String[]{"--clean", "{MC_SRG}", "--output", "{PATCHED}", "--apply", "{BINPATCH}"}));
                profile.getLibraries().add(Library.fromOutput((TaskProvider)signUniversalJar, (Project)this.project, (String)"net.neoforged", (String)"neoforge", (String)this.project.getVersion().toString(), (String)"universal"));
                profile.getIcon().set(this.project.provider(() -> {
                    File icon = new File(this.project.getRootProject().getProjectDir(), "docs/assets/neoforged.ico");
                    if (!icon.exists()) {
                        throw new IllegalStateException("Missing icon.");
                    }
                    return "data:image/png;base64," + new String(Base64.getEncoder().encode(Files.readAllBytes(icon.toPath())));
                }));
                profile.getJson().set((Object)"/version.json");
                profile.getLogo().set((Object)"/big_logo.png");
                profile.getMirrorList().set((Object)"https://mirrors.neoforged.net");
                profile.getWelcome().convention(profile.getProfile().map(name -> "Welcome to the simple " + name + " installer"));
                profile.getShouldHideExtract().set((Object)true);
            });
            Configuration installerJsonInstallerLibrariesConfiguration = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)this.project.getConfigurations(), (String)"InstallerJsonInstallerLibraries", (Dependency[])new Dependency[0]);
            ConfigurationUtils.extendsFrom((Project)this.project, (Configuration)installerJsonInstallerLibrariesConfiguration, (Configuration[])new Configuration[]{installerLibrariesConfiguration});
            installerJsonInstallerLibrariesConfiguration.shouldResolveConsistentlyWith(runtimeClasspath);
            TaskProvider createLegacyInstallerJson = this.project.getTasks().register("createLegacyInstallerJson", CreateLegacyInstallerJson.class, task -> {
                task.getProfile().set((Object)installerProfile);
                task.getLibraries().from(new Object[]{installerJsonInstallerLibrariesConfiguration});
                task.getRepositoryURLs().set((Provider)repoCollection);
                task.dependsOn(new Object[]{signUniversalJar});
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            Configuration installerToolConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.project, (String)"PlatformConfigInstallerLookup", (Dependency[])new Dependency[]{this.project.getDependencies().create((Object)"net.neoforged:legacyinstaller:3.0.+:shrunk")});
            TaskProvider downloadInstaller = this.project.getTasks().register("downloadInstaller", Download.class, task -> {
                task.getInput().from(new Object[]{installerToolConfiguration});
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider createWindowsServerArgsFile = this.project.getTasks().register("createWindowsServerArgsFile", CreateClasspathFiles.class, task -> {
                task.getModulePath().from(new Object[]{moduleOnlyConfiguration});
                task.getClasspath().from(new Object[]{installerRuntimeLibrariesConfiguration});
                task.getClasspath().from(new Object[]{gameLayerLibraryConfiguration});
                task.getClasspath().from(new Object[]{pluginLayerLibraryConfiguration});
                task.getPathSeparator().set((Object)";");
                task.getServer().set(((TaskProvider)runtimeDefinition.getGameArtifactProvidingTasks().get(GameArtifact.SERVER_JAR)).flatMap(OutputSpecification::getOutput));
                task.getNeoFormVersion().set((Object)neoFormVersion);
                DynamicProjectExtension.configureInstallerTokens(task, runtimeDefinition, Lists.newArrayList((Object[])new Configuration[]{moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration}), pluginLayerLibraryConfiguration, gameLayerLibraryConfiguration);
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider createUnixServerArgsFile = this.project.getTasks().register("createUnixServerArgsFile", CreateClasspathFiles.class, task -> {
                task.getModulePath().from(new Object[]{moduleOnlyConfiguration});
                task.getClasspath().from(new Object[]{installerRuntimeLibrariesConfiguration});
                task.getClasspath().from(new Object[]{gameLayerLibraryConfiguration});
                task.getClasspath().from(new Object[]{pluginLayerLibraryConfiguration});
                task.getPathSeparator().set((Object)":");
                task.getServer().set(((TaskProvider)runtimeDefinition.getGameArtifactProvidingTasks().get(GameArtifact.SERVER_JAR)).flatMap(OutputSpecification::getOutput));
                task.getNeoFormVersion().set((Object)neoFormVersion);
                DynamicProjectExtension.configureInstallerTokens(task, runtimeDefinition, Lists.newArrayList((Object[])new Configuration[]{moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration}), pluginLayerLibraryConfiguration, gameLayerLibraryConfiguration);
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            String projectVersion = this.project.getVersion().toString();
            TaskProvider installerJar = this.project.getTasks().register("legacyInstallerJar", CreateLegacyInstaller.class, task -> {
                task.getInstallerCore().set(downloadInstaller.flatMap(OutputSpecification::getOutput));
                task.getInstallerJson().set(createLegacyInstallerJson.flatMap(OutputSpecification::getOutput));
                task.getLauncherJson().set(createLauncherJson.flatMap(OutputSpecification::getOutput));
                task.getClientBinaryPatches().set(((TaskProvider)binaryPatchGenerators.get(DistributionType.CLIENT)).flatMap(OutputSpecification::getOutput));
                task.getServerBinaryPatches().set(((TaskProvider)binaryPatchGenerators.get(DistributionType.SERVER)).flatMap(OutputSpecification::getOutput));
                task.getWindowsServerArgs().set(createWindowsServerArgsFile.flatMap(OutputSpecification::getOutput));
                task.getUnixServerArgs().set(createUnixServerArgsFile.flatMap(OutputSpecification::getOutput));
                task.getData().from(new Object[]{this.project.getRootProject().fileTree((Object)"server_files/").exclude(new String[]{"args.txt"})});
                DynamicProjectExtension.configureInstallerTokens(task, runtimeDefinition, Lists.newArrayList((Object[])new Configuration[]{moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration}), pluginLayerLibraryConfiguration, gameLayerLibraryConfiguration);
                if (this.project.getProperties().containsKey("neogradle.runtime.platform.installer.debug") && Boolean.parseBoolean(this.project.getProperties().get("neogradle.runtime.platform.installer.debug").toString())) {
                    task.from(signUniversalJar.flatMap(OutputSpecification::getOutput), spec -> {
                        spec.into((Object)String.format("/maven/net/neoforged/neoforge/%s/", projectVersion));
                        spec.rename(name -> String.format("neoforge-%s-universal.jar", projectVersion));
                    });
                }
            });
            TaskProvider signInstallerJar = this.project.getTasks().register("signInstallerJar", PotentiallySignJar.class, task -> {
                task.getInput().set(installerJar.flatMap(AbstractArchiveTask::getArchiveFile));
                task.getOutputFileName().set(this.project.provider(() -> String.format("%s-%s-installer.jar", this.project.getName(), this.project.getVersion())));
                task.dependsOn(new Object[]{installerJar});
            });
            userdevProfile.runType("client", type -> {
                type.getEnvironmentVariables().put((Object)"MOD_CLASSES", (Object)"{source_roots}");
                type.getIsClient().set((Object)true);
                type.getIsGameTest().set((Object)true);
                type.getSystemProperties().put((Object)"neoforge.enableGameTest", (Object)"true");
                type.getArguments().add((Object)"--launchTarget");
                type.getArguments().add((Object)"forgeclientuserdev");
                type.getArguments().add((Object)"--version");
                type.getArguments().add((Object)this.project.getVersion().toString());
                type.getArguments().add((Object)"--assetIndex");
                type.getArguments().add((Object)"{asset_index}");
                type.getArguments().add((Object)"--assetsDir");
                type.getArguments().add((Object)"{assets_root}");
                this.configureUserdevRunType((RunType)type, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, userdevCompileOnlyConfiguration, this.project);
            });
            userdevProfile.runType("server", type -> {
                type.getEnvironmentVariables().put((Object)"MOD_CLASSES", (Object)"{source_roots}");
                type.getIsServer().set((Object)true);
                type.getArguments().add((Object)"--launchTarget");
                type.getArguments().add((Object)"forgeserveruserdev");
                this.configureUserdevRunType((RunType)type, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, userdevCompileOnlyConfiguration, this.project);
            });
            userdevProfile.runType("gameTestServer", type -> {
                type.getEnvironmentVariables().put((Object)"MOD_CLASSES", (Object)"{source_roots}");
                type.getIsServer().set((Object)true);
                type.getIsGameTest().set((Object)true);
                type.getSystemProperties().put((Object)"neoforge.enableGameTest", (Object)"true");
                type.getSystemProperties().put((Object)"neoforge.gameTestServer", (Object)"true");
                type.getArguments().add((Object)"--launchTarget");
                type.getArguments().add((Object)"forgeserveruserdev");
                this.configureUserdevRunType((RunType)type, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, userdevCompileOnlyConfiguration, this.project);
            });
            userdevProfile.runType("data", type -> {
                type.getEnvironmentVariables().put((Object)"MOD_CLASSES", (Object)"{source_roots}");
                type.getIsDataGenerator().set((Object)true);
                type.getArguments().add((Object)"--launchTarget");
                type.getArguments().add((Object)"forgedatauserdev");
                type.getArguments().add((Object)"--assetIndex");
                type.getArguments().add((Object)"{asset_index}");
                type.getArguments().add((Object)"--assetsDir");
                type.getArguments().add((Object)"{assets_root}");
                this.configureUserdevRunType((RunType)type, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, userdevCompileOnlyConfiguration, this.project);
            });
            userdevProfile.runType("junit", type -> {
                type.getEnvironmentVariables().put((Object)"MOD_CLASSES", (Object)"{source_roots}");
                type.getEnvironmentVariables().put((Object)"MCP_MAPPINGS", (Object)"{mcp_mappings}");
                type.getIsClient().set((Object)true);
                type.getIsJUnit().set((Object)true);
                type.getArguments().add((Object)"--launchTarget");
                type.getArguments().add((Object)"forgejunituserdev");
                type.getArguments().add((Object)"--version");
                type.getArguments().add((Object)this.project.getVersion().toString());
                type.getArguments().add((Object)"--assetIndex");
                type.getArguments().add((Object)"{asset_index}");
                type.getArguments().add((Object)"--assetsDir");
                type.getArguments().add((Object)"{assets_root}");
                this.configureUserdevRunType((RunType)type, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, userdevCompileOnlyConfiguration, this.project);
            });
            userdevProfile.getNeoForm().set((Object)neoformDependency);
            userdevProfile.getSourcePatchesDirectory().set((Object)"patches/");
            userdevProfile.getAccessTransformerDirectory().set((Object)"ats/");
            userdevProfile.getBinaryPatchFile().set((Object)"joined.lzma");
            userdevProfile.getBinaryPatcher().set((Object)((UserdevProfile.ToolExecution)((UserdevProfile.ToolExecution)this.project.getObjects().newInstance(UserdevProfile.ToolExecution.class, new Object[0])).configure(tool -> {
                tool.getTool().set((Provider)((Subsystems)this.project.getExtensions().getByType(Subsystems.class)).getTools().getBinaryPatcher());
                tool.getArguments().addAll((Object[])new String[]{"--clean", "{clean}", "--output", "{output}", "--apply", "{patch}"});
            })));
            userdevProfile.getSourcesJarArtifactCoordinate().set((Object)DynamicProjectExtension.createCoordinate(this.project, "sources"));
            userdevProfile.getUniversalJarArtifactCoordinate().set((Object)DynamicProjectExtension.createCoordinate(this.project, "universal"));
            Configuration userdevJsonLibrariesConfiguration = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)this.project.getConfigurations(), (String)"userdevLibraries", (Dependency[])new Dependency[0]);
            ConfigurationUtils.extendsFrom((Project)this.project, (Configuration)userdevJsonLibrariesConfiguration, (Configuration[])new Configuration[]{userdevCompileOnlyConfiguration, installerLibrariesConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, moduleOnlyConfiguration});
            userdevJsonLibrariesConfiguration.shouldResolveConsistentlyWith(runtimeClasspath);
            Configuration userdevJsonModuleOnlyConfiguration = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)this.project.getConfigurations(), (String)"userdevModuleOnly", (Dependency[])new Dependency[0]);
            ConfigurationUtils.extendsFrom((Project)this.project, (Configuration)userdevJsonModuleOnlyConfiguration, (Configuration[])new Configuration[]{moduleOnlyConfiguration});
            userdevJsonLibrariesConfiguration.shouldResolveConsistentlyWith(runtimeClasspath);
            Configuration userdevJsonUserdevTestImplementationConfiguration = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)this.project.getConfigurations(), (String)"userdevJsonUserdevTestImplementation", (Dependency[])new Dependency[0]);
            ConfigurationUtils.extendsFrom((Project)this.project, (Configuration)userdevJsonUserdevTestImplementationConfiguration, (Configuration[])new Configuration[]{userdevTestImplementationConfiguration});
            userdevJsonUserdevTestImplementationConfiguration.shouldResolveConsistentlyWith(runtimeClasspath);
            TaskProvider createUserdevJson = this.project.getTasks().register("createUserdevJson", CreateUserdevJson.class, task -> {
                task.getProfile().set((Object)userdevProfile);
                task.getLibraries().from(new Object[]{userdevJsonLibrariesConfiguration});
                task.getModules().from(new Object[]{userdevJsonModuleOnlyConfiguration});
                task.getTestLibraries().from(new Object[]{userdevJsonUserdevTestImplementationConfiguration});
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            TaskProvider packPatches = this.project.getTasks().register("packPatches", PackJar.class, task -> {
                task.getInputFiles().from(new Object[]{this.project.fileTree((Object)patches).matching(filterable -> filterable.include(new String[]{"**/*.patch"}))});
                CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
            });
            if (!parchmentArtifact.isPresent()) {
                bakePatches = this.project.getTasks().register("bakePatches", BakePatches.class, task -> {
                    task.getInput().set(packPatches.flatMap(OutputSpecification::getOutput));
                    CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
                });
            } else {
                File sourceSetDir = SetupUtils.getSetupSourceTarget(this.project);
                TaskProvider<DefaultExecute> sourcesWithoutParchment = RuntimeDevRuntimeExtension.applyParchment(this.project, "reverseParchment", (Provider<File>)mergeMappings.flatMap(OutputSpecification::getOutput).map(RegularFile::getAsFile), (Provider<String>)this.project.provider(() -> ""), (Provider<File>)this.project.provider(() -> sourceSetDir), false, runtimeDefinition.getSpecification(), workingDirectory, (TaskProvider<? extends WithOutput>)strippedJar);
                sourcesWithoutParchment.configure(withOutput -> withOutput.getProgramArguments().add((Object)"--ignore-prefix=mcp/"));
                bakePatches = this.project.getTasks().register("createRenamedSourcePatches", GenerateSourcePatches.class, task -> {
                    task.getBase().set(neoFormSources.flatMap(OutputSpecification::getOutput));
                    task.getModified().set(sourcesWithoutParchment.flatMap(OutputSpecification::getOutput));
                    task.getShouldCreateAutomaticHeader().set((Object)false);
                    CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
                });
            }
            AccessTransformers accessTransformers = (AccessTransformers)this.project.getExtensions().getByType(AccessTransformers.class);
            TaskProvider userdevJar = this.project.getTasks().register("userdevJar", Jar.class, task -> {
                task.getArchiveClassifier().set((Object)"userdev");
                task.getArchiveAppendix().set((Object)"userdev");
                task.getArchiveVersion().set((Object)this.project.getVersion().toString());
                task.getArchiveBaseName().set((Object)this.project.getName());
                task.getDestinationDirectory().set(this.project.getLayout().getBuildDirectory().dir("libs"));
                task.getArchiveFileName().set(this.project.provider(() -> String.format("%s-%s-userdev.jar", this.project.getName(), this.project.getVersion())));
                task.dependsOn(new Object[]{bakePatches});
                FileTree bakedPatches = this.project.zipTree((Object)((RegularFile)((WithOutput)bakePatches.get()).getOutput().get()).getAsFile());
                task.from((Object)createUserdevJson.flatMap(OutputSpecification::getOutput), spec -> spec.rename(name -> "config.json"));
                task.from((Object)accessTransformers.getFiles(), spec -> spec.into((Object)"ats/"));
                task.from((Object)((TaskProvider)binaryPatchGenerators.get(DistributionType.JOINED)).flatMap(OutputSpecification::getOutput), spec -> spec.rename(name -> "joined.lzma"));
                task.from((Object)bakedPatches, spec -> spec.into((Object)"patches/"));
            });
            TaskProvider assembleTask = this.project.getTasks().named("assemble");
            assembleTask.configure(task -> {
                task.dependsOn(new Object[]{signInstallerJar});
                task.dependsOn(new Object[]{signUniversalJar});
                task.dependsOn(new Object[]{userdevJar});
                task.dependsOn(new Object[]{sourcesJarProvider});
            });
        });
    }

    private TaskProvider<SetupProjectFromRuntime> configureSetupTasks(Provider<RegularFile> rawJarProvider, SourceSet mainSource, Configuration minecraftDependencies) {
        IdeManagementExtension ideManagementExtension = (IdeManagementExtension)this.project.getExtensions().getByType(IdeManagementExtension.class);
        TaskProvider ideImportTask = ideManagementExtension.getOrCreateIdeImportTask();
        TaskProvider projectSetup = this.project.getTasks().register("setup", SetupProjectFromRuntime.class, task -> {
            task.getSourcesFile().set(rawJarProvider);
            task.dependsOn(new Object[]{ideImportTask});
        });
        Configuration apiConfiguration = this.project.getConfigurations().getByName(mainSource.getApiConfigurationName());
        minecraftDependencies.getAllDependencies().forEach(dep -> apiConfiguration.getDependencies().add(dep));
        Project rootProject = this.project.getRootProject();
        if (!rootProject.getTasks().getNames().contains("setup")) {
            rootProject.getTasks().create("setup");
        }
        rootProject.getTasks().named("setup").configure(task -> task.dependsOn(new Object[]{projectSetup}));
        return projectSetup;
    }

    private void configureRunType(Project project, RunType runType, Configuration moduleOnlyConfiguration, Configuration gameLayerLibraryConfiguration, Configuration pluginLayerLibraryConfiguration, RuntimeDevRuntimeDefinition runtimeDefinition) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        Configuration runtimeClasspath = project.getConfigurations().getByName(mainSourceSet.getRuntimeClasspathConfigurationName());
        runType.getMainClass().set((Object)"cpw.mods.bootstraplauncher.BootstrapLauncher");
        runType.getSystemProperties().put((Object)"java.net.preferIPv6Addresses", (Object)"system");
        runType.getJvmArguments().addAll((Object[])new String[]{"-p", moduleOnlyConfiguration.getAsPath()});
        runType.getSystemProperties().put((Object)"ignoreList", DynamicProjectExtension.createIgnoreList(project, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration));
        runType.getSystemProperties().put((Object)"mergeModules", (Object)"jna-5.10.0.jar,jna-platform-5.10.0.jar");
        runType.getSystemProperties().put((Object)"fml.pluginLayerLibraries", DynamicProjectExtension.collectFileNames(pluginLayerLibraryConfiguration, project));
        runType.getSystemProperties().put((Object)"fml.gameLayerLibraries", DynamicProjectExtension.collectFileNames(gameLayerLibraryConfiguration, project));
        runType.getSystemProperties().put((Object)"legacyClassPath", (Object)project.getConfigurations().getByName("runtimeClasspath").getAsPath());
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-modules", "ALL-MODULE-PATH"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-opens", "java.base/java.util.jar=cpw.mods.securejarhandler"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-opens", "java.base/java.lang.invoke=cpw.mods.securejarhandler"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-exports", "java.base/sun.security.util=cpw.mods.securejarhandler"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-exports", "jdk.naming.dns/com.sun.jndi.dns=java.naming"});
        runType.getEnvironmentVariables().put((Object)"NEOFORGE_SPEC", (Object)project.getVersion().toString().substring(0, project.getVersion().toString().lastIndexOf(".")));
        runType.getClasspath().from(new Object[]{runtimeClasspath});
        runType.getRunTemplate().getArguments().addAll(TransformerUtils.ifTrue((Provider)runType.getRunTemplate().getIsClient(), (Object[])new String[]{"--username", "Dev", "--version", project.getName(), "--accessToken", "0", "--launchTarget", "forgeclientdev"}));
        runType.getRunTemplate().getArguments().addAll(TransformerUtils.ifTrue((Provider)runType.getRunTemplate().getIsServer(), (Object[])new String[]{"--launchTarget", "forgeserverdev"}));
        runType.getRunTemplate().getSystemProperties().putAll(TransformerUtils.ifTrueMap((Provider)runType.getRunTemplate().getIsGameTest(), (Object)"neoforge.enableGameTest", (Object)"true"));
        runType.getRunTemplate().getSystemProperties().putAll(TransformerUtils.ifTrueMap((Provider)runType.getRunTemplate().getIsGameTest().flatMap(TransformerUtils.and((Provider[])new Provider[]{runType.getRunTemplate().getIsServer()})), (Object)"neoforge.gameTestServer", (Object)"true"));
        runType.getRunTemplate().getArguments().addAll(TransformerUtils.ifTrue((Provider)runType.getRunTemplate().getIsDataGenerator(), (Object[])new String[]{"--launchTarget", "forgedatadev", "--flat", "--all", "--validate", "--output", project.getRootProject().file((Object)"src/generated/resources/").getAbsolutePath()}));
        mainSourceSet.getResources().getSrcDirs().forEach(file -> runType.getRunTemplate().getArguments().addAll(TransformerUtils.ifTrue((Provider)runType.getRunTemplate().getIsDataGenerator(), (Object[])new String[]{"--existing", file.getAbsolutePath()})));
        Provider assetsDir = DownloadAssets.getAssetsDirectory((Project)project).map(Directory::getAsFile).map(File::getAbsolutePath);
        Provider assetIndex = runtimeDefinition.getAssets().flatMap(DownloadAssets::getAssetIndex);
        runType.getRunTemplate().getArguments().addAll(TransformerUtils.ifTrue((Provider)runType.getRunTemplate().getIsDataGenerator().flatMap(TransformerUtils.or((Provider[])new Provider[]{runType.getRunTemplate().getIsClient(), runType.getRunTemplate().getIsJUnit()})), (Provider[])new Provider[]{project.provider(() -> "--assetsDir"), assetsDir, project.provider(() -> "--assetIndex"), assetIndex}));
        runType.getRunTemplate().getArguments().addAll(TransformerUtils.ifTrue((Provider)runType.getRunTemplate().getIsJUnit(), (Object[])new String[]{"--launchTarget", "forgejunitdev"}));
    }

    private static void configureInstallerTokens(TokenizedTask tokenizedTask, RuntimeDevRuntimeDefinition runtimeDefinition, Collection<Configuration> ignoreConfigurations, Configuration pluginLayerLibraries, Configuration gameLayerLibraries) {
        tokenizedTask.token("TASK", "forgeserver");
        tokenizedTask.token("MAVEN_PATH", String.format("%s/%s/%s", tokenizedTask.getProject().getGroup().toString().replace('.', '/'), tokenizedTask.getProject().getName(), tokenizedTask.getProject().getVersion()));
        tokenizedTask.token("FORGE_VERSION", tokenizedTask.getProject().getVersion());
        tokenizedTask.token("FML_VERSION", tokenizedTask.getProject().getProperties().get("fancy_mod_loader_version"));
        tokenizedTask.token("MC_VERSION", ((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion());
        tokenizedTask.token("MCP_VERSION", DynamicProjectExtension.extractNeoformVersion(runtimeDefinition));
        tokenizedTask.token("FORGE_GROUP", tokenizedTask.getProject().getGroup());
        tokenizedTask.token("IGNORE_LIST", ignoreConfigurations.stream().flatMap(config -> config.getFiles().stream()).map(File::getName).collect(Collectors.joining(",")));
        tokenizedTask.token("PLUGIN_LAYER_LIBRARIES", pluginLayerLibraries.getFiles().stream().map(File::getName).collect(Collectors.joining(",")));
        tokenizedTask.token("GAME_LAYER_LIBRARIES", gameLayerLibraries.getFiles().stream().map(File::getName).collect(Collectors.joining(",")));
        tokenizedTask.token("MODULES", "ALL-MODULE-PATH");
    }

    private static String extractNeoformVersion(RuntimeDevRuntimeDefinition runtimeDefinition) {
        String completeVersion = ((NeoFormRuntimeSpecification)runtimeDefinition.getJoinedNeoFormRuntimeDefinition().getSpecification()).getNeoFormVersion();
        return completeVersion.substring(completeVersion.lastIndexOf("-") + 1);
    }

    private static Provider<String> collectFileNames(Configuration config, Project project) {
        return project.provider(() -> config.getFiles().stream().map(File::getName).collect(Collectors.joining(",")));
    }

    @NotNull
    private static Provider<String> createIgnoreList(Project project, Configuration ... configurations) {
        return project.provider(() -> {
            StringBuilder ignoreList = new StringBuilder(1000);
            for (Configuration cfg : configurations) {
                if (cfg.isEmpty()) continue;
                ignoreList.append(cfg.getFiles().stream().map(File::getName).collect(Collectors.joining(","))).append(",");
            }
            ignoreList.append("client-extra").append(",").append(project.getName()).append("-");
            return ignoreList.toString();
        });
    }

    private static Provider<String> collectFilePaths(Configuration config, String prefix, String seperator, Project project) {
        return project.provider(() -> {
            ArtifactPathsCollector collector = new ArtifactPathsCollector(project.getObjects(), seperator, prefix);
            config.getAsFileTree().visit((FileVisitor)collector);
            return collector.toString();
        });
    }

    private void configureRun(Run run, RuntimeDevRuntimeDefinition runtimeDefinition) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
        run.getConfigureAutomatically().set((Object)true);
        run.getConfigureFromDependencies().set((Object)false);
        run.getDependsOn().addAll(TransformerUtils.ifTrue((Provider)run.getIsClient(), (Provider[])new Provider[]{runtimeDefinition.getAssets(), runtimeDefinition.getNatives()}));
    }

    private TaskProvider<? extends WithOutput> createCleanProvider(TaskProvider<? extends WithOutput> jarProvider, RuntimeDevRuntimeDefinition runtimeDefinition, File workingDirectory) {
        RuntimeDevRuntimeSpecification spec = (RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification();
        Provider versionData = this.project.provider(() -> {
            HashMap data = Maps.newHashMap();
            Mappings mappingsExtension = (Mappings)this.project.getExtensions().getByType(Mappings.class);
            HashMap mappingVersionData = Maps.newHashMap();
            mappingVersionData.put("version", ((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion());
            mappingVersionData.put("minecraft", ((RuntimeDevRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion());
            mappingVersionData.putAll((Map)mappingsExtension.getVersion().get());
            return data;
        });
        HashSet additionalRuntimeTasks = Sets.newHashSet();
        TaskBuildingContext context = new TaskBuildingContext(spec.getProject(), String.format("mapCleanFor%s", StringUtils.capitalize((String)jarProvider.getName())), taskName -> CommonRuntimeUtils.buildTaskName((Specification)spec, (String)taskName), jarProvider, runtimeDefinition.getGameArtifactProvidingTasks(), versionData, (Set)additionalRuntimeTasks, (Definition)runtimeDefinition);
        TaskProvider remapTask = ((ApplyMappingsToCompiledJarTaskBuilder)context.getNamingChannel().getApplyCompiledMappingsTaskBuilder().get()).build(context);
        additionalRuntimeTasks.forEach(taskProvider -> taskProvider.configure(task -> CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory)));
        remapTask.configure(task -> CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory));
        return remapTask;
    }

    private TaskProvider<? extends WithOutput> createFlippedMojMapProvider(TaskProvider<? extends WithOutput> mojmapProvider, RuntimeDevRuntimeDefinition runtimeDefinition, File workingDirectory) {
        String taskName = String.format("invert%s", StringUtils.capitalize((String)mojmapProvider.getName()));
        if (this.project.getTasks().getNames().contains(taskName)) {
            return this.project.getTasks().named(taskName, WriteIMappingsFile.class);
        }
        return this.project.getTasks().register(taskName, WriteIMappingsFile.class, task -> {
            task.getMappings().set(mojmapProvider.flatMap(OutputSpecification::getOutput).map(TransformerUtils.guard(file -> IMappingFile.load((File)file.getAsFile()))).map(file -> new CacheableIMappingFile(file.reverse())));
            CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
        });
    }

    private Provider<RegularFile> renameCompiledJar(TaskProvider<? extends WithOutput> mappingsFile, TaskProvider<? extends Jar> input, RuntimeDevRuntimeDefinition runtimeDefinition, File workingDirectory) {
        Provider inputFile = input.flatMap(AbstractArchiveTask::getArchiveFile);
        return this.project.getTasks().register(CommonRuntimeUtils.buildTaskName((Definition)runtimeDefinition, (String)"renameCompiledJar"), DefaultExecute.class, task -> {
            task.getArguments().putRegularFile("mappings", mappingsFile.flatMap(OutputSpecification::getOutput));
            task.getArguments().putRegularFile("input", inputFile);
            task.getExecutingJar().fileProvider(ToolUtilities.resolveTool((Project)this.project, Tools::getAutoRenamingTool));
            task.getProgramArguments().addAll((Object[])new String[]{"--names", "{mappings}"});
            task.getProgramArguments().addAll((Object[])new String[]{"--input", "{input}"});
            task.getProgramArguments().addAll((Object[])new String[]{"--output", "{output}"});
            task.getProgramArguments().add((Object)"--disable-abstract-param");
            ((SourceSet)((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getCompileClasspath().forEach(f -> task.getProgramArguments().addAll((Object[])new String[]{"--lib", f.getAbsolutePath()}));
            task.dependsOn(new Object[]{input});
            task.dependsOn(new Object[]{mappingsFile});
            CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (CommonRuntimeDefinition)runtimeDefinition, (File)workingDirectory);
        }).flatMap(OutputSpecification::getOutput);
    }

    private void configureUserdevRunType(RunType runType, Configuration moduleOnlyConfiguration, Configuration gameLayerLibraryConfiguration, Configuration pluginLayerLibraryConfiguration, Configuration userdevCompileOnlyConfiguration, Project project) {
        runType.getMainClass().set((Object)"cpw.mods.bootstraplauncher.BootstrapLauncher");
        runType.getArguments().addAll((Object[])new String[]{"--gameDir", "."});
        runType.getSystemProperties().put((Object)"java.net.preferIPv6Addresses", (Object)"system");
        runType.getSystemProperties().put((Object)"ignoreList", DynamicProjectExtension.createIgnoreList(project, moduleOnlyConfiguration, gameLayerLibraryConfiguration, pluginLayerLibraryConfiguration, userdevCompileOnlyConfiguration));
        runType.getSystemProperties().put((Object)"fml.pluginLayerLibraries", DynamicProjectExtension.collectFileNames(pluginLayerLibraryConfiguration, project));
        runType.getSystemProperties().put((Object)"fml.gameLayerLibraries", DynamicProjectExtension.collectFileNames(gameLayerLibraryConfiguration, project));
        runType.getSystemProperties().put((Object)"mergeModules", (Object)"jna-5.10.0.jar,jna-platform-5.10.0.jar");
        runType.getSystemProperties().put((Object)"legacyClassPath.file", (Object)"{minecraft_classpath_file}");
        runType.getJvmArguments().addAll((Object[])new String[]{"-p", "{modules}"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-modules", "ALL-MODULE-PATH"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-opens", "java.base/java.util.jar=cpw.mods.securejarhandler"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-opens", "java.base/java.lang.invoke=cpw.mods.securejarhandler"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-exports", "java.base/sun.security.util=cpw.mods.securejarhandler"});
        runType.getJvmArguments().addAll((Object[])new String[]{"--add-exports", "jdk.naming.dns/com.sun.jndi.dns=java.naming"});
    }

    private static String createCoordinate(Project project, String classifier) {
        return Objects.toString(Artifact.from((Project)project, (String)classifier, (String)"jar"));
    }

    @NotNull
    public DynamicProjectType getType() {
        if (this.type == null) {
            throw new IllegalStateException("Project is not configured yet!");
        }
        return this.type;
    }

    @DSLProperty
    public abstract Property<Boolean> getIsUpdating();

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @DSLProperty
    public abstract Property<String> getParchment();
}

