/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.dsl.platform.util.CoordinateCollector;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CreateUserdevJson
extends DefaultRuntime
implements WithOutput,
WithWorkspace {
    public CreateUserdevJson() {
        this.getOutputFileName().set((Object)"config.json");
    }

    @TaskAction
    public void doTask() throws Exception {
        Gson gson = UserdevProfile.createGson((ObjectFactory)this.getObjectFactory());
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        UserdevProfile profile = (UserdevProfile)this.getProfile().get();
        UserdevProfile clone = (UserdevProfile)gson.fromJson(gson.toJson((Object)profile), UserdevProfile.class);
        this.collect(this.getLibraries(), (ListProperty<String>)clone.getAdditionalDependencyArtifactCoordinates());
        this.collect(this.getTestLibraries(), (ListProperty<String>)clone.getAdditionalTestDependencyArtifactCoordinates());
        this.collect(this.getModules(), (ListProperty<String>)clone.getModules());
        String json = gson.toJson((Object)clone);
        try {
            Files.write(output.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void collect(ConfigurableFileCollection libraries, ListProperty<String> coords) {
        CoordinateCollector collector = new CoordinateCollector(this.getObjectFactory());
        libraries.getAsFileTree().visit((FileVisitor)collector);
        coords.addAll((Iterable)collector.getCoordinates());
    }

    @Nested
    public abstract Property<UserdevProfile> getProfile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getLibraries();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getTestLibraries();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getModules();
}

