/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.dsl.platform.model.LauncherProfile;
import net.neoforged.gradle.dsl.platform.util.LibraryCollector;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CreateLauncherJson
extends DefaultRuntime
implements WithOutput,
WithWorkspace {
    public CreateLauncherJson() {
        this.getOutputFileName().set((Object)"version.json");
    }

    @TaskAction
    public void run() {
        Gson gson = LauncherProfile.createGson((ObjectFactory)this.getObjectFactory());
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        LauncherProfile profile = (LauncherProfile)this.getProfile().get();
        LauncherProfile clone = (LauncherProfile)gson.fromJson(gson.toJson((Object)profile), LauncherProfile.class);
        clone.getLibraries().addAll(this.getProviderFactory().provider(() -> {
            this.getLogger().info("Collecting libraries for Launcher Profile");
            LibraryCollector profileFiller = new LibraryCollector(this.getObjectFactory(), (List)this.getRepositoryURLs().get(), this.getLogger());
            this.getLibraries().getAsFileTree().visit((FileVisitor)profileFiller);
            return profileFiller.getLibraries();
        }));
        String json = gson.toJson((Object)clone);
        try {
            Files.write(output.toPath(), json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nested
    public abstract Property<LauncherProfile> getProfile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getLibraries();

    @Input
    public abstract ListProperty<URI> getRepositoryURLs();
}

