/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.dsl.platform.model.InstallerProfile;
import net.neoforged.gradle.dsl.platform.util.LibraryCollector;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CreateLegacyInstallerJson
extends DefaultRuntime
implements WithOutput,
WithWorkspace {
    public CreateLegacyInstallerJson() {
        this.getOutputFileName().set((Object)"install_profile.json");
    }

    @TaskAction
    public void run() {
        Gson gson = InstallerProfile.createGson((ObjectFactory)this.getObjectFactory());
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        InstallerProfile profile = (InstallerProfile)this.getProfile().get();
        InstallerProfile copy = (InstallerProfile)gson.fromJson(gson.toJson((Object)profile), InstallerProfile.class);
        copy.getLibraries().addAll(this.getProviderFactory().provider(() -> {
            LibraryCollector profileFiller = new LibraryCollector(this.getObjectFactory(), (List)this.getRepositoryURLs().get());
            this.getLibraries().getAsFileTree().visit((FileVisitor)profileFiller);
            return profileFiller.getLibraries();
        }));
        try {
            Files.write(output.toPath(), gson.toJson((Object)copy).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nested
    public abstract Property<InstallerProfile> getProfile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getLibraries();

    @Input
    public abstract ListProperty<URI> getRepositoryURLs();
}

