/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.tasks;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.DiffOperation;
import codechicken.diffpatch.util.LogLevel;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.OutputStream;
import java.nio.file.Path;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateSourcePatches
extends DefaultRuntime
implements WithOutput,
WithWorkspace {
    public GenerateSourcePatches() {
        this.getOriginalPrefix().convention((Object)"a/");
        this.getModifiedPrefix().convention((Object)"b/");
        this.getLineEnding().convention((Object)"\n");
        this.getShouldOutputVerboseLogging().convention((Object)false);
        this.getContextLines().convention((Object)-1);
        this.getShouldCreateAutomaticHeader().convention((Object)true);
        this.getShouldPrintSummary().convention((Object)false);
    }

    @TaskAction
    public void doTask() throws Exception {
        Path base = ((RegularFile)this.getBase().get()).getAsFile().toPath();
        Path modified = ((RegularFile)this.getModified().get()).getAsFile().toPath();
        Path output = ((RegularFile)this.getOutput().get()).getAsFile().toPath();
        this.getProject().getLogger().info("Base: {}", (Object)base);
        this.getProject().getLogger().info("Modified: {}", (Object)modified);
        DiffOperation.Builder builder = DiffOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), org.gradle.api.logging.LogLevel.LIFECYCLE)).aPath(base).bPath(modified).outputPath(output, ArchiveFormat.findFormat((Path)output.getFileName())).autoHeader(((Boolean)this.getShouldCreateAutomaticHeader().get()).booleanValue()).level((Boolean)this.getShouldOutputVerboseLogging().get() != false ? LogLevel.ALL : LogLevel.WARN).summary(((Boolean)this.getShouldPrintSummary().get()).booleanValue()).aPrefix((String)this.getOriginalPrefix().get()).bPrefix((String)this.getModifiedPrefix().get()).lineEnding((String)this.getLineEnding().get());
        if ((Integer)this.getContextLines().get() != -1) {
            builder.context(((Integer)this.getContextLines().get()).intValue());
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
    }

    @InputFile
    public abstract RegularFileProperty getBase();

    @InputFile
    public abstract RegularFileProperty getModified();

    @Input
    @Optional
    public abstract Property<String> getOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getModifiedPrefix();

    @Input
    public abstract Property<String> getLineEnding();

    @Input
    public abstract Property<Boolean> getShouldCreateAutomaticHeader();

    @Input
    @Optional
    public abstract Property<Integer> getContextLines();

    @Input
    @Optional
    public abstract Property<Boolean> getShouldOutputVerboseLogging();

    @Input
    @Optional
    public abstract Property<Boolean> getShouldPrintSummary();
}

