/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.extension;

import codechicken.diffpatch.util.PatchMode;
import java.io.File;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.ArtifactProvider;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.platform.runtime.runtime.definition.RuntimeDevRuntimeDefinition;
import net.neoforged.gradle.platform.runtime.runtime.specification.RuntimeDevRuntimeSpecification;
import net.neoforged.gradle.platform.runtime.runtime.tasks.ApplyPatches;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class RuntimeDevRuntimeExtension
extends CommonRuntimeExtension<RuntimeDevRuntimeSpecification, RuntimeDevRuntimeSpecification.Builder, RuntimeDevRuntimeDefinition> {
    @Inject
    public RuntimeDevRuntimeExtension(Project project) {
        super(project);
    }

    @NotNull
    protected RuntimeDevRuntimeDefinition doCreate(RuntimeDevRuntimeSpecification spec) {
        File workingDirectory = ((Directory)spec.getProject().getLayout().getBuildDirectory().dir(String.format("platform/%s", spec.getIdentifier())).get()).getAsFile();
        NeoFormRuntimeDefinition neoformRuntime = spec.getNeoFormRuntime();
        TaskProvider patchApply = spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)"applyPatches"), ApplyPatches.class, task -> {
            task.getBase().set(neoformRuntime.getSourceJarTask().flatMap(OutputSpecification::getOutput));
            task.getPatches().set((Object)spec.getPatchesDirectory());
            task.getRejects().set((Object)spec.getRejectsDirectory());
            task.getPatchMode().set((Object)(spec.isUpdating() ? PatchMode.FUZZY : PatchMode.ACCESS));
            task.getShouldFailOnPatchFailure().set((Object)(!spec.isUpdating() ? 1 : 0));
            RuntimeDevRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (String)"applyPatches", (CommonRuntimeSpecification)spec, (File)workingDirectory);
        });
        TaskProvider sourcesProvider = spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)"sourceFromAppliedPatches"), ArtifactProvider.class, task -> {
            task.getInputFiles().from(new Object[]{patchApply.flatMap(OutputSpecification::getOutput)});
            task.getOutput().set(new File(workingDirectory, "patched.jar"));
        });
        return new RuntimeDevRuntimeDefinition(spec, neoformRuntime, (TaskProvider<? extends ArtifactProvider>)sourcesProvider);
    }

    protected RuntimeDevRuntimeSpecification.Builder createBuilder() {
        return RuntimeDevRuntimeSpecification.Builder.from(this.getProject());
    }

    protected void bakeDefinition(RuntimeDevRuntimeDefinition definition) {
        RuntimeDevRuntimeSpecification spec = (RuntimeDevRuntimeSpecification)definition.getSpecification();
        Minecraft minecraftExtension = (Minecraft)spec.getProject().getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        definition.onBake((NamingChannel)mappingsExtension.getChannel().get(), ((Directory)spec.getProject().getLayout().getBuildDirectory().get()).dir("userdev").dir(spec.getIdentifier()).getAsFile());
    }
}

