/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.extensions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;

public abstract class DynamicProjectManagementExtension {
    private final Settings settings;
    private final Map<String, ProjectDescriptor> knownDynamicDescriptors = new HashMap<String, ProjectDescriptor>();

    @Inject
    public DynamicProjectManagementExtension(Settings settings) {
        this.settings = settings;
    }

    public void include(String ... projectPaths) {
        this.include(Arrays.asList(projectPaths));
    }

    public void include(Iterable<String> projectPaths) {
        this.settings.include(projectPaths);
        for (String projectPath : projectPaths) {
            this.knownDynamicDescriptors.put(projectPath, this.settings.project(projectPath));
        }
    }

    public ProjectDescriptor project(String path) throws UnknownProjectException {
        if (!this.knownDynamicDescriptors.containsKey(path)) {
            throw new UnknownProjectException(String.format("The given path: %s does not target a dynamic project", path));
        }
        return this.knownDynamicDescriptors.get(path);
    }

    @Nullable
    public ProjectDescriptor findProject(String path) {
        return this.knownDynamicDescriptors.get(path);
    }

    public Collection<ProjectDescriptor> getDynamicProjects() {
        return this.knownDynamicDescriptors.values();
    }
}

