/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.specification;

import com.google.common.collect.Multimap;
import java.util.Objects;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.Artifact;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.platform.runtime.runtime.extension.RuntimeDevRuntimeExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public final class RuntimeDevRuntimeSpecification
extends CommonRuntimeSpecification {
    private final Artifact neoFormArtifact;
    private final String minecraftVersion;
    private final FileCollection additionalDependencies;
    private final Directory patchesDirectory;
    private final Directory rejectsDirectory;
    private final boolean isUpdating;

    public RuntimeDevRuntimeSpecification(Project project, DistributionType distribution, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Artifact neoFormArtifact, FileCollection additionalDependencies, Directory patchesDirectory, Directory rejectsDirectory, boolean isUpdating) {
        super(project, "platform", neoFormArtifact.getVersion(), distribution, preTaskTypeAdapters, postTypeAdapters, RuntimeDevRuntimeExtension.class);
        this.minecraftVersion = neoFormArtifact.getVersion().substring(0, neoFormArtifact.getVersion().lastIndexOf("-"));
        this.neoFormArtifact = neoFormArtifact;
        this.additionalDependencies = additionalDependencies;
        this.patchesDirectory = patchesDirectory;
        this.rejectsDirectory = rejectsDirectory;
        this.isUpdating = isUpdating;
    }

    @NotNull
    public String getMinecraftVersion() {
        return Objects.requireNonNull(this.minecraftVersion, "Minecraft version not set");
    }

    public Artifact getNeoFormArtifact() {
        return this.neoFormArtifact;
    }

    public FileCollection getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public Directory getPatchesDirectory() {
        return this.patchesDirectory;
    }

    public Directory getRejectsDirectory() {
        return this.rejectsDirectory;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeDevRuntimeSpecification that = (RuntimeDevRuntimeSpecification)((Object)o);
        return Objects.equals(this.neoFormArtifact, that.neoFormArtifact) && Objects.equals(this.minecraftVersion, that.minecraftVersion) && Objects.equals(this.additionalDependencies, that.additionalDependencies) && Objects.equals(this.patchesDirectory, that.patchesDirectory) && Objects.equals(this.rejectsDirectory, that.rejectsDirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.neoFormArtifact, this.minecraftVersion, this.additionalDependencies, this.patchesDirectory, this.rejectsDirectory);
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<RuntimeDevRuntimeSpecification, Builder> {
        private Provider<String> neoFormGroup;
        private Provider<String> neoFormName;
        private Provider<String> neoFormVersion;
        private Provider<Artifact> neoFormArtifact;
        private FileCollection additionalDependencies;
        private Provider<Directory> patchesDirectory;
        private Provider<Directory> rejectsDirectory;
        private Provider<Boolean> isUpdating;

        private Builder(Project project) {
            super(project);
            this.additionalDependencies = project.getObjects().fileCollection();
            this.neoFormGroup = project.provider(() -> "net.neoforged");
            this.neoFormName = project.provider(() -> "neoform");
            this.neoFormVersion = project.provider(() -> "+");
            this.neoFormArtifact = this.neoFormGroup.flatMap(group -> this.neoFormName.flatMap(name -> this.neoFormVersion.map(version -> Artifact.from((String)String.format("%s:%s:%s@zip", group, name, version)))));
            this.patchesDirectory = project.provider(() -> project.getLayout().getProjectDirectory().dir("patches"));
            this.rejectsDirectory = project.provider(() -> project.getLayout().getProjectDirectory().dir("rejects"));
            this.isUpdating = project.provider(() -> false);
        }

        protected Builder getThis() {
            return this;
        }

        public static Builder from(Project project) {
            return new Builder(project);
        }

        public Builder withNeoFormGroup(Provider<String> neoFormGroup) {
            this.neoFormGroup = neoFormGroup;
            return this.getThis();
        }

        public Builder withNeoFormGroup(String neoFormGroup) {
            if (neoFormGroup == null) {
                return this.getThis();
            }
            return this.withNeoFormGroup((Provider<String>)this.project.provider(() -> neoFormGroup));
        }

        public Builder withNeoFormName(Provider<String> neoFormName) {
            this.neoFormName = neoFormName;
            return this.getThis();
        }

        public Builder withNeoFormName(String neoFormName) {
            if (neoFormName == null) {
                return this.getThis();
            }
            return this.withNeoFormName((Provider<String>)this.project.provider(() -> neoFormName));
        }

        public Builder withNeoFormVersion(Provider<String> neoFormVersion) {
            this.neoFormVersion = neoFormVersion;
            return this.getThis();
        }

        public Builder withNeoFormVersion(String neoFormVersion) {
            if (neoFormVersion == null) {
                return this.getThis();
            }
            return this.withNeoFormVersion((Provider<String>)this.project.provider(() -> neoFormVersion));
        }

        public Builder withNeoFormArtifact(Provider<Artifact> neoFormArtifact) {
            this.neoFormArtifact = neoFormArtifact;
            return this.getThis();
        }

        public Builder withNeoFormArtifact(Artifact neoFormArtifact) {
            if (neoFormArtifact == null) {
                return this.getThis();
            }
            return this.withNeoFormArtifact((Provider<Artifact>)this.project.provider(() -> neoFormArtifact));
        }

        public Builder withPatchesDirectory(Provider<Directory> patchesDirectory) {
            this.patchesDirectory = patchesDirectory;
            return this.getThis();
        }

        public Builder withPatchesDirectory(Directory patchesDirectory) {
            if (patchesDirectory == null) {
                return this.getThis();
            }
            return this.withPatchesDirectory((Provider<Directory>)this.project.provider(() -> patchesDirectory));
        }

        public Builder withRejectsDirectory(Provider<Directory> rejectsDirectory) {
            this.rejectsDirectory = rejectsDirectory;
            return this.getThis();
        }

        public Builder withRejectsDirectory(Directory rejectsDirectory) {
            if (rejectsDirectory == null) {
                return this.getThis();
            }
            return this.withRejectsDirectory((Provider<Directory>)this.project.provider(() -> rejectsDirectory));
        }

        public Builder isUpdating(Provider<Boolean> isUpdating) {
            this.isUpdating = isUpdating;
            return this.getThis();
        }

        public Builder isUpdating(Boolean isUpdating) {
            if (isUpdating == null) {
                return this.getThis();
            }
            return this.isUpdating((Provider<Boolean>)this.project.provider(() -> isUpdating));
        }

        public Builder withAdditionalDependencies(FileCollection files) {
            this.additionalDependencies = this.additionalDependencies.plus(files);
            return this.getThis();
        }

        @NotNull
        public RuntimeDevRuntimeSpecification build() {
            Provider resolvedArtifact = this.neoFormArtifact.map(a -> Builder.resolveNeoFormVersion(this.project, a));
            return new RuntimeDevRuntimeSpecification(this.project, (DistributionType)this.distributionType.get(), (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, (Artifact)resolvedArtifact.get(), this.additionalDependencies, (Directory)this.patchesDirectory.get(), (Directory)this.rejectsDirectory.get(), (Boolean)this.isUpdating.get());
        }

        private static Artifact resolveNeoFormVersion(Project project, Artifact current) {
            if (!Objects.equals(current.getVersion(), "+")) {
                return current;
            }
            Configuration resolveConfig = ConfigurationUtils.temporaryConfiguration((Project)project, (Dependency[])new Dependency[]{current.toDependency(project)});
            return resolveConfig.getResolvedConfiguration().getResolvedArtifacts().stream().filter(current.asArtifactMatcher()).findFirst().map(Artifact::from).orElse(current);
        }
    }
}

