/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform;

import java.util.Optional;
import net.neoforged.gradle.platform.PlatformPlugin;
import net.neoforged.gradle.platform.extensions.DynamicProjectManagementExtension;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.initialization.Settings;
import org.jetbrains.annotations.NotNull;

public class PlatformSettingsPlugin
implements Plugin<Settings> {
    public void apply(@NotNull Settings target) {
        target.getExtensions().create("dynamicProjects", DynamicProjectManagementExtension.class, new Object[]{target});
        target.getPlugins().apply("org.gradle.toolchains.foojay-resolver-convention");
        target.getGradle().beforeProject((Action)new DynamicProjectPluginAdapter(target));
        target.pluginManagement(spec -> spec.repositories(repositories -> {
            repositories.gradlePluginPortal();
            repositories.maven(mavenConfig -> {
                mavenConfig.setUrl((Object)"https://maven.neoforged.net/releases");
                mavenConfig.setName("NeoForged");
            });
            repositories.mavenLocal();
        }));
    }

    private static final class DynamicProjectPluginAdapter
    implements Action<Project> {
        private final Settings settings;

        private DynamicProjectPluginAdapter(Settings settings) {
            this.settings = settings;
        }

        public void execute(@NotNull Project project) {
            DynamicProjectManagementExtension projectManagementExtension = (DynamicProjectManagementExtension)this.settings.getExtensions().getByType(DynamicProjectManagementExtension.class);
            Optional<ProjectDescriptor> match = projectManagementExtension.getDynamicProjects().stream().filter(desc -> desc.getName().equals(project.getName())).findFirst();
            match.ifPresent(desc -> {
                PlatformPlugin cfr_ignored_0 = (PlatformPlugin)project.getPlugins().apply(PlatformPlugin.class);
            });
        }
    }
}

