/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.dependency;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.Context;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.ReplacementResult;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.neoform.dependency.NeoFormReplacementResult;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.util.NeoFormRuntimeUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.Nullable;

public final class NeoFormDependencyManager {
    private NeoFormDependencyManager() {
    }

    public static void apply(Project project) {
        DependencyReplacement dependencyReplacer = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacer.getReplacementHandlers().create("neoForm", handler -> handler.getReplacer().set(NeoFormDependencyManager::replaceDependency));
    }

    private static Optional<ReplacementResult> replaceDependency(Context context) {
        ModuleDependency dependency = context.getDependency();
        NeoFormTarget target = NeoFormDependencyManager.getNeoFormTargetFromDependency(dependency);
        if (target == null) {
            return Optional.empty();
        }
        if (target.version == null) {
            throw new IllegalStateException("Version is missing on NeoForm dependency " + String.valueOf(dependency));
        }
        Project project = context.getProject();
        NeoFormRuntimeExtension runtimeExtension = (NeoFormRuntimeExtension)((Object)project.getExtensions().getByType(NeoFormRuntimeExtension.class));
        NeoFormRuntimeDefinition runtime = (NeoFormRuntimeDefinition)runtimeExtension.maybeCreateFor((Dependency)dependency, builder -> {
            ((NeoFormRuntimeSpecification.Builder)builder.withDistributionType(target.distribution)).withNeoFormVersion(target.version);
            NeoFormRuntimeUtils.configureDefaultRuntimeSpecBuilder(project, builder, project.files(new Object[0]));
        });
        return Optional.of(new NeoFormReplacementResult(project, (TaskProvider<? extends WithOutput>)runtime.getSourceJarTask(), (TaskProvider<? extends WithOutput>)runtime.getRawJarTask(), ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)project.getConfigurations(), (String)("neoform_mdk_" + target.distribution.getName().toLowerCase()), (Dependency[])new Dependency[0]), runtime.getMinecraftDependenciesConfiguration(), Collections.emptySet(), runtime));
    }

    @Nullable
    private static NeoFormTarget getNeoFormTargetFromDependency(ModuleDependency dependency) {
        DistributionType distributionType;
        if (!"net.minecraft".equals(dependency.getGroup())) {
            return null;
        }
        switch (dependency.getName()) {
            case "neoform_client": {
                distributionType = DistributionType.CLIENT;
                break;
            }
            case "neoform_server": {
                distributionType = DistributionType.SERVER;
                break;
            }
            case "neoform_joined": {
                distributionType = DistributionType.JOINED;
                break;
            }
            default: {
                return null;
            }
        }
        if (!NeoFormDependencyManager.hasMatchingArtifact(dependency)) {
            return null;
        }
        return new NeoFormTarget(dependency.getVersion(), distributionType);
    }

    private static boolean hasMatchingArtifact(ModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().isEmpty()) {
            return true;
        }
        return NeoFormDependencyManager.hasSourcesArtifact(externalModuleDependency);
    }

    private static boolean hasSourcesArtifact(ModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return Objects.equals(artifact.getClassifier(), "sources") && Objects.equals(artifact.getExtension(), "jar");
    }

    private static final class NeoFormTarget {
        private final String version;
        private final DistributionType distribution;

        public NeoFormTarget(String version, DistributionType distribution) {
            this.version = version;
            this.distribution = distribution;
        }
    }
}

