/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class StripJar
extends DefaultRuntime {
    public StripJar() {
        this.getIsWhitelistMode().convention((Object)true);
        this.getIsWhitelistMode().finalizeValueOnRead();
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    protected void run() throws Throwable {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, (ICacheableJob)ICacheableJob.Default.file(this::doRun, (RegularFileProperty[])new RegularFileProperty[]{this.getOutput()})).execute();
    }

    protected void doRun() throws Exception {
        File input = ((RegularFile)this.getInput().get()).getAsFile();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        boolean isWhitelist = (Boolean)this.getIsWhitelistMode().get();
        this.strip(input, output, isWhitelist);
    }

    private void strip(File input, File output, boolean whitelist) throws IOException {
        try (ZipFile jar = new ZipFile(input);
             JarOutputStream outputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(output)));){
            Enumeration<? extends ZipEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().endsWith(".class") != whitelist) continue;
                outputStream.putNextEntry(entry);
                try (InputStream is = jar.getInputStream(entry);){
                    is.transferTo(outputStream);
                }
                outputStream.closeEntry();
            }
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @Input
    public abstract Property<Boolean> getIsWhitelistMode();
}

