/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.tasks.RuntimeArgumentsImpl;
import net.neoforged.gradle.common.runtime.tasks.RuntimeMultiArgumentsImpl;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeMultiArguments;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Jar tasks are not cached either")
public abstract class PackJar
extends Zip
implements Runtime {
    private final Property<JavaLanguageVersion> javaVersion;
    private final Provider<JavaToolchainService> javaToolchainService;
    private final RuntimeArguments arguments = (RuntimeArguments)this.getObjectFactory().newInstance(RuntimeArgumentsImpl.class, new Object[0]);
    private final RuntimeMultiArguments multiArguments = (RuntimeMultiArguments)this.getObjectFactory().newInstance(RuntimeMultiArgumentsImpl.class, new Object[]{this.getProviderFactory()});

    public PackJar() {
        this.javaVersion = this.getProject().getObjects().property(JavaLanguageVersion.class);
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class);
        this.javaToolchainService = this.getProviderFactory().provider(() -> service);
        this.getArchiveExtension().set((Object)"jar");
        this.setPreserveFileTimestamps(false);
        this.setReproducibleFileOrder(true);
        this.from(new Object[]{this.getInputFiles()});
        this.getStepsDirectory().convention(this.getRuntimeDirectory().dir("steps"));
        this.getOutputDirectory().convention(this.getStepsDirectory().flatMap(d -> this.getStepName().map(arg_0 -> ((Directory)d).dir(arg_0))));
        this.getOutputFileName().convention(this.getArguments().getOrDefault("outputExtension", this.getProviderFactory().provider(() -> "jar")).map(extension -> String.format("outputs.%s", extension)).orElse((Object)"outputs.jar"));
        this.getOutput().convention(this.getOutputDirectory().flatMap(d -> this.getOutputFileName().orElse((Object)"outputs.jar").map(arg_0 -> ((Directory)d).file(arg_0))));
        this.getOutputDirectory().finalizeValueOnRead();
    }

    public Provider<RegularFile> getArchiveFile() {
        return this.getOutput();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInputFiles();

    @Inject
    public abstract ObjectFactory getObjectFactory();

    @Nested
    public RuntimeArguments getArguments() {
        return this.arguments;
    }

    @Nested
    public RuntimeMultiArguments getMultiArguments() {
        return this.multiArguments;
    }

    @Internal
    public final Provider<JavaToolchainService> getJavaToolChain() {
        return this.javaToolchainService;
    }

    @Nested
    @Optional
    public Property<JavaLanguageVersion> getJavaVersion() {
        return this.javaVersion;
    }
}

