/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.neoform.runtime.tasks.AbstractInjectSource;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.Nullable;

public abstract class InjectFromDirectorySource
extends AbstractInjectSource {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getDirectory();

    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        File packageInfoTemplateFile = ((RegularFile)this.getDirectory().file("package-info-template.java").get()).getAsFile();
        if (packageInfoTemplateFile.exists()) {
            return Files.readAllBytes(packageInfoTemplateFile.toPath());
        }
        return null;
    }

    @Override
    public void copyTo(ZipOutputStream out) {
        FileTree source = this.getDirectory().getAsFileTree().matching((PatternFilterable)this.createFilter());
        source.visit((FileVisitor)new ZipBuildingFileTreeVisitor(out));
    }
}

