/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.util;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.gradle.common.util.JavaSourceTransformAdapterUtils;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV1;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public final class NeoFormRuntimeUtils {
    private static final Pattern OUTPUT_REPLACE_PATTERN = Pattern.compile("^\\{(\\w+)Output}$");

    private NeoFormRuntimeUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: NeoFormRuntimeUtils. This is a utility class");
    }

    public static Provider<File> getTaskInputFor(NeoFormRuntimeSpecification spec, Map<String, TaskProvider<? extends WithOutput>> tasks, NeoFormConfigConfigurationSpecV1.Step step, Task task) {
        String inputValue = step.getValue("input");
        if (inputValue == null) {
            throw new IllegalStateException("Can not transformer or get an input of a task without an input");
        }
        return NeoFormRuntimeUtils.getInputForTaskFrom(spec, inputValue, tasks, task);
    }

    public static Provider<File> getInputForTaskFrom(NeoFormRuntimeSpecification spec, String inputValue, Map<String, TaskProvider<? extends WithOutput>> tasks, Task task) {
        Matcher matcher = OUTPUT_REPLACE_PATTERN.matcher(inputValue);
        if (!matcher.find()) {
            return spec.getProject().provider(() -> new File(inputValue));
        }
        String stepName = matcher.group(1);
        if (stepName != null) {
            String taskName = CommonRuntimeUtils.buildTaskName((Specification)spec, (String)stepName);
            switch (stepName) {
                case "downloadManifest": {
                    taskName = String.format("%s%s", "cacheLauncherMetadata", spec.getMinecraftVersion());
                    break;
                }
                case "downloadJson": {
                    taskName = String.format("%s%s", "cacheVersionManifest", spec.getMinecraftVersion());
                    break;
                }
                case "downloadClient": {
                    taskName = String.format("%s%s", "cacheVersionExecutableClient", spec.getMinecraftVersion());
                    break;
                }
                case "downloadServer": {
                    taskName = String.format("%s%s", "cacheVersionExecutableServer", spec.getMinecraftVersion());
                    break;
                }
                case "downloadClientMappings": {
                    taskName = String.format("%s%s", "cacheVersionMappingsClient", spec.getMinecraftVersion());
                    break;
                }
                case "downloadServerMappings": {
                    taskName = String.format("%s%s", "cacheVersionMappingsServer", spec.getMinecraftVersion());
                    break;
                }
                case "extractServer": {
                    taskName = String.format("%s%s", "cacheVersionExtractedServer", spec.getMinecraftVersion());
                }
            }
            String finalTaskName = taskName;
            TaskProvider inputTask = tasks.computeIfAbsent(taskName, value -> {
                throw new IllegalArgumentException("Could not find NeoForm task for input: " + value + ", available tasks: " + String.valueOf(tasks.keySet()) + ", input: " + inputValue + " taskname: " + finalTaskName + " stepname: " + stepName);
            });
            task.dependsOn(new Object[]{inputTask});
            return inputTask.flatMap(t -> t.getOutput().getAsFile());
        }
        throw new IllegalStateException("The string '" + inputValue + "' did not return a valid substitution match!");
    }

    public static Optional<TaskProvider<? extends WithOutput>> getInputTaskForTaskFrom(NeoFormRuntimeSpecification spec, String inputValue, Map<String, TaskProvider<? extends WithOutput>> tasks) {
        Matcher matcher = OUTPUT_REPLACE_PATTERN.matcher(inputValue);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String stepName = matcher.group(1);
        if (stepName != null) {
            String taskName = CommonRuntimeUtils.buildTaskName((Specification)spec, (String)stepName);
            switch (stepName) {
                case "downloadManifest": {
                    taskName = String.format("%s%s", "cacheLauncherMetadata", spec.getMinecraftVersion());
                    break;
                }
                case "downloadJson": {
                    taskName = String.format("%s%s", "cacheVersionManifest", spec.getMinecraftVersion());
                    break;
                }
                case "downloadClient": {
                    taskName = String.format("%s%s", "cacheVersionExecutableClient", spec.getMinecraftVersion());
                    break;
                }
                case "downloadServer": {
                    taskName = String.format("%s%s", "cacheVersionExecutableServer", spec.getMinecraftVersion());
                    break;
                }
                case "downloadClientMappings": {
                    taskName = String.format("%s%s", "cacheVersionMappingsClient", spec.getMinecraftVersion());
                    break;
                }
                case "downloadServerMappings": {
                    taskName = String.format("%s%s", "cacheVersionMappingsServer", spec.getMinecraftVersion());
                }
            }
            String finalTaskName = taskName;
            return Optional.ofNullable(tasks.get(finalTaskName));
        }
        return Optional.empty();
    }

    public static void configureDefaultRuntimeSpecBuilder(Project project, NeoFormRuntimeSpecification.Builder builder, ConfigurableFileCollection systemAccessTransformers) {
        builder.withPreTaskAdapter("recompile", JavaSourceTransformAdapterUtils.createCustomizationsAdapter((Project)project, (FileCollection)systemAccessTransformers));
    }
}

