/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class UnpackZip
extends DefaultRuntime {
    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public void execute(InputChanges inputChanges) throws IOException {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, (ICacheableJob)ICacheableJob.Default.directory((DirectoryProperty)this.getOutputDirectory(), () -> this.doTask(inputChanges))).execute();
    }

    private void doTask(InputChanges inputChanges) throws IOException {
        File output = ((Directory)this.getOutputDirectory().get()).getAsFile();
        if (!output.exists()) {
            output.mkdirs();
        }
        if (!inputChanges.isIncremental()) {
            CopyingFileTreeVisitor visitor = new CopyingFileTreeVisitor(output);
            this.getInput().getAsFileTree().visit((FileVisitor)visitor);
            return;
        }
        for (FileChange fileChange : inputChanges.getFileChanges((FileCollection)this.getInput())) {
            File outputFile;
            if (fileChange.getChangeType() == ChangeType.REMOVED) {
                outputFile = new File(output, fileChange.getNormalizedPath());
                if (!outputFile.exists()) continue;
                outputFile.delete();
                continue;
            }
            outputFile = new File(output, fileChange.getNormalizedPath());
            Files.copy(fileChange.getFile().toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInput();

    public Provider<FileTree> getOutputAsTree() {
        return this.getOutputDirectory().map(it -> this.getObjectFactory().fileTree().from(it));
    }
}

