/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.PatchOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchMode;
import java.io.File;
import java.nio.file.Path;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public abstract class Patch
extends DefaultRuntime {
    public Patch() {
        this.getRejectsFile().fileProvider(this.getFileInOutputDirectory("rejects.zip"));
        this.getIsVerbose().convention((Object)false);
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public void run() throws Throwable {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, (ICacheableJob)ICacheableJob.Default.file(this::doRun, (RegularFileProperty[])new RegularFileProperty[]{this.getOutput()})).execute();
    }

    private void doRun() throws Exception {
        boolean success;
        File input = ((RegularFile)this.getInput().get()).getAsFile();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        File rejects = ((RegularFile)this.getRejectsFile().get()).getAsFile();
        String patchDirectory = (String)this.getPatchDirectory().get();
        ExtractingAndRootCollectingVisitor patchArchiveLocator = new ExtractingAndRootCollectingVisitor(patchDirectory);
        this.getPatchArchive().getAsFileTree().matching(filterable -> filterable.include(fileTreeElement -> {
            String path = fileTreeElement.getPath();
            if (patchDirectory.startsWith(path)) {
                return true;
            }
            return (fileTreeElement.getPath() + "/").startsWith(patchDirectory);
        })).visit((FileVisitor)patchArchiveLocator);
        if (patchArchiveLocator.directory == null) {
            throw new RuntimeException("Patch directory not found.");
        }
        PatchOperation.Builder builder = PatchOperation.builder().logTo(arg_0 -> ((Logger)this.getLogger()).lifecycle(arg_0)).baseInput((Input)Input.MultiInput.detectedArchive((Path)input.toPath())).patchesInput((Input)Input.MultiInput.folder((Path)patchArchiveLocator.directory.toPath())).patchedOutput((Output)Output.MultiOutput.detectedArchive((Path)output.toPath())).rejectsOutput((Output)Output.MultiOutput.detectedArchive((Path)rejects.toPath())).level((Boolean)this.getIsVerbose().get() != false ? LogLevel.ALL : LogLevel.WARN).mode(PatchMode.OFFSET);
        if (this.getPatchesModifiedPrefix().isPresent()) {
            builder = builder.bPrefix((String)this.getPatchesModifiedPrefix().get());
        }
        if (this.getPatchesOriginalPrefix().isPresent()) {
            builder = builder.aPrefix((String)this.getPatchesOriginalPrefix().get());
        }
        CliOperation.Result result = builder.build().operate();
        boolean bl = success = result.exit == 0;
        if (!success) {
            this.getProject().getLogger().error("Rejects saved to: {}", (Object)rejects);
            throw new RuntimeException("Patch failure.");
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getPatchArchive();

    @org.gradle.api.tasks.Input
    public abstract Property<String> getPatchDirectory();

    @OutputFile
    public abstract RegularFileProperty getRejectsFile();

    @org.gradle.api.tasks.Input
    public abstract Property<Boolean> getIsVerbose();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<String> getPatchesOriginalPrefix();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<String> getPatchesModifiedPrefix();

    private static final class ExtractingAndRootCollectingVisitor
    implements FileVisitor {
        private final String filter;
        private File directory;

        private ExtractingAndRootCollectingVisitor(String filter) {
            this.filter = filter;
        }

        public void visitDir(@NotNull FileVisitDetails dirDetails) {
            if (this.directory == null && (dirDetails.getRelativePath().getPathString() + "/").startsWith(this.filter)) {
                this.directory = dirDetails.getFile();
            }
            dirDetails.getFile();
        }

        public void visitFile(@NotNull FileVisitDetails fileDetails) {
            fileDetails.getFile();
        }
    }
}

