/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.neoform.runtime.tasks.AbstractInjectSource;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.Nullable;

public abstract class InjectFromFileTreeSource
extends AbstractInjectSource {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getFiles();

    @Optional
    @Input
    public abstract Property<String> getTreePrefix();

    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        String lookupPath = this.buildTreePrefix() + path;
        FileTree matching = this.getFiles().getAsFileTree().matching((PatternFilterable)this.createFilter()).matching(pattern -> pattern.include(new String[]{lookupPath}));
        if (matching.isEmpty()) {
            return null;
        }
        return Files.readAllBytes(matching.getSingleFile().toPath());
    }

    @Override
    public void copyTo(ZipOutputStream out) throws IOException {
        if (this.getFiles().isEmpty()) {
            return;
        }
        FileTree source = this.getFiles().getAsFileTree().matching((PatternFilterable)this.createFilter());
        source.visit((FileVisitor)new ZipBuildingFileTreeVisitor(out){

            protected ZipEntry createDirectory(FileVisitDetails fileVisitDetails) {
                Object path = fileVisitDetails.getRelativePath().getPathString();
                if (((String)path).startsWith(InjectFromFileTreeSource.this.buildTreePrefix())) {
                    path = ((String)path).substring(InjectFromFileTreeSource.this.buildTreePrefix().length());
                }
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                return new ZipEntry((String)path);
            }

            protected ZipEntry createFile(FileVisitDetails fileVisitDetails) {
                String path = fileVisitDetails.getRelativePath().getPathString();
                if (path.startsWith(InjectFromFileTreeSource.this.buildTreePrefix())) {
                    path = path.substring(InjectFromFileTreeSource.this.buildTreePrefix().length());
                }
                return new ZipEntry(path);
            }
        });
    }

    private String buildTreePrefix() {
        if (this.getTreePrefix().isPresent()) {
            String prefix = (String)this.getTreePrefix().get();
            if (!prefix.endsWith("/")) {
                return prefix + "/";
            }
            return prefix;
        }
        return "";
    }
}

