/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.extensions;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.neoforged.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.runtime.tasks.ListLibraries;
import net.neoforged.gradle.common.tasks.ArtifactFromOutput;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.extensions.ConfigurationData;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Decompiler;
import net.neoforged.gradle.dsl.common.extensions.subsystems.DecompilerLogLevel;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.InputFileSpecification;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV1;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV2;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.runtime.tasks.InjectFromFileTreeSource;
import net.neoforged.gradle.neoform.runtime.tasks.InjectZipContent;
import net.neoforged.gradle.neoform.runtime.tasks.Patch;
import net.neoforged.gradle.neoform.runtime.tasks.StripJar;
import net.neoforged.gradle.neoform.util.NeoFormRuntimeUtils;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class NeoFormRuntimeExtension
extends CommonRuntimeExtension<NeoFormRuntimeSpecification, NeoFormRuntimeSpecification.Builder, NeoFormRuntimeDefinition>
implements ConfigurableDSLElement<NeoFormRuntimeExtension> {
    private static final Set<String> DISABLED_STEPS = Sets.newHashSet((Object[])new String[]{"downloadManifest", "downloadJson"});

    @Inject
    public NeoFormRuntimeExtension(Project project) {
        super(project);
    }

    private static void configureMcpRuntimeTaskWithDefaults(NeoFormRuntimeSpecification spec, File neoFormDirectory, Map<String, String> symbolicDataSources, LinkedHashMap<String, TaskProvider<? extends WithOutput>> tasks, NeoFormConfigConfigurationSpecV1.Step step, Runtime neoFormRuntimeTask, Optional<TaskProvider<? extends WithOutput>> alternativeInputProvider) {
        NeoFormRuntimeExtension.buildArguments(neoFormRuntimeTask.getArguments(), spec, step, tasks, neoFormRuntimeTask, alternativeInputProvider);
        NeoFormRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)neoFormRuntimeTask, symbolicDataSources, (String)step.getName(), (Specification)spec, (File)neoFormDirectory);
        neoFormRuntimeTask.getNeoFormArchive().from(new Object[]{spec.getNeoFormArchive()});
    }

    private static void configureMcpRuntimeTaskWithDefaults(NeoFormRuntimeSpecification spec, File neoFormDirectory, Map<String, String> symbolicDataSources, Runtime neoFormRuntimeTask) {
        NeoFormRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)neoFormRuntimeTask, symbolicDataSources, (String)CommonRuntimeUtils.buildStepName((Specification)spec, (String)neoFormRuntimeTask.getName()), (Specification)spec, (File)neoFormDirectory);
        neoFormRuntimeTask.getNeoFormArchive().from(new Object[]{spec.getNeoFormArchive()});
    }

    @Nullable
    private static TaskProvider<? extends WithOutput> createBuiltIn(NeoFormRuntimeSpecification spec, NeoFormRuntimeDefinition definition, NeoFormConfigConfigurationSpecV2 neoFormConfigV2, NeoFormConfigConfigurationSpecV1.Step step, Map<String, TaskProvider<? extends WithOutput>> tasks, Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactTaskProviders, MinecraftArtifactCache cache, Optional<TaskProvider<? extends WithOutput>> adaptedInput) {
        switch (step.getType()) {
            case "decompile": {
                return NeoFormRuntimeExtension.createDecompile(spec, step, neoFormConfigV2);
            }
            case "downloadClient": {
                return gameArtifactTaskProviders.computeIfAbsent(GameArtifact.CLIENT_JAR, a -> {
                    throw new IllegalStateException("Client Jar is required for this step, but was not provided");
                });
            }
            case "downloadServer": {
                return gameArtifactTaskProviders.computeIfAbsent(GameArtifact.SERVER_JAR, a -> {
                    throw new IllegalStateException("Server Jar is required for this step, but was not provided");
                });
            }
            case "strip": {
                return spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)step.getName()), StripJar.class, task -> task.getInput().fileProvider(NeoFormRuntimeUtils.getTaskInputFor(spec, tasks, step, (Task)task)));
            }
            case "listLibraries": {
                return spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)step.getName()), ListLibraries.class, task -> task.getVersionJsonLibraries().from(new Object[]{NeoFormRuntimeExtension.extractVersionJsonLibraries((Project)spec.getProject(), (String)spec.getMinecraftVersion(), (CommonRuntimeDefinition)definition)}));
            }
            case "inject": {
                return spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)step.getName()), InjectZipContent.class, task -> {
                    task.getInjectionSource().fileProvider(NeoFormRuntimeUtils.getTaskInputFor(spec, tasks, step, (Task)task));
                    task.getInjectedSources().add(task.getRuntimeData().map(data -> (FileTree)data.get("inject")).map(inject -> {
                        InjectFromFileTreeSource fileTreeSource = (InjectFromFileTreeSource)task.getObjectFactory().newInstance(InjectFromFileTreeSource.class, new Object[0]);
                        fileTreeSource.getFiles().from(new Object[]{inject.matching(fileTree -> {
                            if (spec.getDistribution().equals((Object)DistributionType.SERVER)) {
                                fileTree.include(new String[]{"**/server/**"});
                            } else if (spec.getDistribution().equals((Object)DistributionType.CLIENT)) {
                                fileTree.include(new String[]{"**/client/**"});
                            }
                        })});
                        fileTreeSource.getTreePrefix().set(task.getSymbolicDataSources().map(data -> (String)data.get("inject")));
                        return fileTreeSource;
                    }));
                });
            }
            case "patch": {
                return spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)step.getName()), Patch.class, task -> {
                    task.getInput().fileProvider(NeoFormRuntimeUtils.getTaskInputFor(spec, tasks, step, (Task)task));
                    task.getPatchArchive().from(new Object[]{spec.getProject().fileTree(spec.getNeoFormArchive())});
                    task.getPatchDirectory().set((Object)neoFormConfigV2.getData(new String[]{"patches", spec.getDistribution().getName()}));
                });
            }
            case "bundleExtractJar": {
                return gameArtifactTaskProviders.computeIfAbsent(GameArtifact.EXTRACTED_SERVER_JAR, a -> {
                    throw new IllegalStateException("Extracted Server Jar is required for this step, but was not provided");
                });
            }
        }
        if (neoFormConfigV2.getSpec() >= 2) {
            switch (step.getType()) {
                case "downloadClientMappings": {
                    return gameArtifactTaskProviders.computeIfAbsent(GameArtifact.CLIENT_MAPPINGS, a -> {
                        throw new IllegalStateException("Client Mappings are required for this step, but were not provided");
                    });
                }
                case "downloadServerMappings": {
                    return gameArtifactTaskProviders.computeIfAbsent(GameArtifact.SERVER_MAPPINGS, a -> {
                        throw new IllegalStateException("Server Mappings are required for this step, but were not provided");
                    });
                }
            }
        }
        return null;
    }

    @NotNull
    private static TaskProvider<? extends Runtime> createDecompile(NeoFormRuntimeSpecification spec, NeoFormConfigConfigurationSpecV1.Step step, NeoFormConfigConfigurationSpecV2 neoFormConfig) {
        NeoFormConfigConfigurationSpecV1.Function function = neoFormConfig.getFunction(step.getType());
        if (function == null) {
            throw new IllegalArgumentException(String.format("Invalid NeoForm Config, Unknown function step type: %s File: %s", step.getType(), neoFormConfig));
        }
        ArrayList<Object> decompilerArgs = new ArrayList<Object>(function.getArgs());
        decompilerArgs.removeIf(arg -> arg.startsWith("--log-level") || arg.startsWith("-log=") || arg.startsWith("--thread-count") || arg.startsWith("-thr="));
        String defaultMaxMemory = "4g";
        ArrayList<CallSite> jvmArgs = new ArrayList<CallSite>(function.getJvmArgs());
        for (int i = jvmArgs.size() - 1; i >= 0; --i) {
            if (!((String)jvmArgs.get(i)).startsWith("-Xmx")) continue;
            defaultMaxMemory = ((String)jvmArgs.get(i)).substring("-Xmx".length());
            jvmArgs.remove(i);
        }
        Decompiler settings = ((Subsystems)spec.getProject().getExtensions().getByType(Subsystems.class)).getDecompiler();
        String maxMemory = (String)settings.getMaxMemory().getOrElse((Object)defaultMaxMemory);
        int maxThreads = (Integer)settings.getMaxThreads().getOrElse((Object)0);
        String logLevel = NeoFormRuntimeExtension.getDecompilerLogLevelArg((DecompilerLogLevel)settings.getLogLevel().getOrElse((Object)DecompilerLogLevel.INFO), function.getVersion());
        jvmArgs.addAll((Collection)settings.getJvmArgs().get());
        jvmArgs.add((CallSite)((Object)("-Xmx" + maxMemory)));
        if (maxThreads > 0) {
            decompilerArgs.add(0, "-thr=" + maxThreads);
        }
        decompilerArgs.add(0, "-log=" + logLevel);
        return spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)step.getName()), DefaultExecute.class, task -> {
            task.getExecutingJar().set(ToolUtilities.resolveTool((Project)task.getProject(), (String)function.getVersion()));
            task.getJvmArguments().addAll((Iterable)jvmArgs);
            task.getProgramArguments().addAll((Iterable)decompilerArgs);
        });
    }

    private static String getDecompilerLogLevelArg(DecompilerLogLevel logLevel, String version) {
        return switch (logLevel) {
            case DecompilerLogLevel.TRACE -> "trace";
            case DecompilerLogLevel.INFO -> "info";
            case DecompilerLogLevel.WARN -> "warn";
            case DecompilerLogLevel.ERROR -> "error";
            default -> throw new GradleException("LogLevel " + String.valueOf(logLevel) + " not supported by " + version);
        };
    }

    private TaskProvider<? extends Runtime> createExecute(NeoFormRuntimeSpecification spec, NeoFormConfigConfigurationSpecV1.Step step, NeoFormConfigConfigurationSpecV1.Function function) {
        return spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)step.getName()), DefaultExecute.class, task -> {
            task.getExecutingJar().set(ToolUtilities.resolveTool((Project)task.getProject(), (String)function.getVersion()));
            task.getJvmArguments().addAll((Iterable)function.getJvmArgs());
            task.getProgramArguments().addAll((Iterable)function.getArgs());
        });
    }

    private static void buildArguments(RuntimeArguments arguments, NeoFormRuntimeSpecification spec, NeoFormConfigConfigurationSpecV1.Step step, Map<String, TaskProvider<? extends WithOutput>> tasks, Runtime taskForArguments, Optional<TaskProvider<? extends WithOutput>> alternativeInputProvider) {
        step.getValues().forEach((key, value) -> {
            if (value.startsWith("{") && value.endsWith("}")) {
                Optional<TaskProvider<? extends WithOutput>> dependentTask = !Objects.equals(key, "input") || alternativeInputProvider.isEmpty() ? NeoFormRuntimeUtils.getInputTaskForTaskFrom(spec, value, tasks) : alternativeInputProvider;
                dependentTask.ifPresent(xva$0 -> taskForArguments.dependsOn(new Object[]{xva$0}));
                dependentTask.ifPresent(task -> arguments.putRegularFile(key, task.flatMap(OutputSpecification::getOutput)));
            } else {
                arguments.put(key, spec.getProject().provider(() -> value));
            }
        });
    }

    @NotNull
    private static Map<String, String> buildDataFilesMap(NeoFormConfigConfigurationSpecV2 neoFormConfig, DistributionType side) {
        return neoFormConfig.getData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() instanceof Map ? (String)((Map)e.getValue()).get(side.getName()) : (String)e.getValue()));
    }

    @NotNull
    protected NeoFormRuntimeDefinition doCreate(NeoFormRuntimeSpecification spec) {
        if (this.definitions.containsKey(spec.getIdentifier())) {
            throw new IllegalArgumentException("Cannot register runtime with identifier '" + spec.getIdentifier() + "' because it already exists");
        }
        Minecraft minecraftExtension = (Minecraft)spec.getProject().getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        MinecraftArtifactCache artifactCacheExtension = (MinecraftArtifactCache)spec.getProject().getExtensions().getByType(MinecraftArtifactCache.class);
        File minecraftCache = ((Directory)artifactCacheExtension.getCacheDirectory().get()).getAsFile();
        MinecraftArtifactCache artifactCache = (MinecraftArtifactCache)spec.getProject().getExtensions().getByType(MinecraftArtifactCache.class);
        Map gameArtifactTasks = NeoFormRuntimeExtension.buildDefaultArtifactProviderTasks((Specification)spec);
        Provider versionJson = artifactCache.cacheVersionManifest(spec.getMinecraftVersion()).map(TransformerUtils.guard(VersionJson::get));
        Configuration minecraftDependenciesConfiguration = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)spec.getProject().getConfigurations(), (String)("NeoFormMinecraftDependenciesFor" + spec.getIdentifier()), (Dependency[])new Dependency[0]);
        minecraftDependenciesConfiguration.getDependencies().addAllLater(versionJson.map(VersionJson::getLibraries).map(libraries -> libraries.stream().map(library -> this.getProject().getDependencies().create((Object)library.getName())).collect(Collectors.toList())));
        File neoFormDirectory = ((Directory)((ConfigurationData)spec.getProject().getExtensions().getByType(ConfigurationData.class)).getLocation().dir(String.format("neoForm/%s", spec.getIdentifier())).get()).getAsFile();
        File stepsMcpDirectory = new File(neoFormDirectory, "steps");
        stepsMcpDirectory.mkdirs();
        NeoFormConfigConfigurationSpecV2 neoFormConfig = spec.getConfig();
        neoFormConfig.getLibraries(spec.getDistribution().getName()).forEach(library -> minecraftDependenciesConfiguration.getDependencies().add((Object)spec.getProject().getDependencies().create(library)));
        Map<String, String> symbolicDataSources = NeoFormRuntimeExtension.buildDataFilesMap(neoFormConfig, spec.getDistribution());
        TaskProvider sourceJarTask = spec.getProject().getTasks().register("supplySourcesFor" + spec.getIdentifier(), ArtifactFromOutput.class, task -> task.getOutput().set(new File(neoFormDirectory, "sources.jar")));
        TaskProvider rawJarTask = spec.getProject().getTasks().register("supplyRawJarFor" + spec.getIdentifier(), ArtifactFromOutput.class, task -> task.getOutput().set(new File(neoFormDirectory, "raw.jar")));
        return new NeoFormRuntimeDefinition(spec, new LinkedHashMap<String, TaskProvider<? extends WithOutput>>(), (TaskProvider<? extends ArtifactFromOutput>)sourceJarTask, (TaskProvider<? extends ArtifactFromOutput>)rawJarTask, gameArtifactTasks, minecraftDependenciesConfiguration, taskProvider -> taskProvider.configure(runtimeTask -> NeoFormRuntimeExtension.configureMcpRuntimeTaskWithDefaults(spec, neoFormDirectory, symbolicDataSources, runtimeTask)), (Provider<VersionJson>)versionJson, neoFormConfig, (TaskProvider<DownloadAssets>)this.createDownloadAssetsTasks(spec, versionJson), (TaskProvider<ExtractNatives>)this.createExtractNativesTasks(spec, symbolicDataSources, neoFormDirectory, versionJson));
    }

    protected void afterRegistration(NeoFormRuntimeDefinition runtime) {
        ProjectUtils.afterEvaluate((Project)((NeoFormRuntimeSpecification)runtime.getSpecification()).getProject(), () -> this.bakeDefinition(runtime));
    }

    protected NeoFormRuntimeSpecification.Builder createBuilder() {
        return NeoFormRuntimeSpecification.Builder.from(this.getProject());
    }

    protected void bakeDefinition(NeoFormRuntimeDefinition definition) {
        NeoFormRuntimeSpecification spec = (NeoFormRuntimeSpecification)definition.getSpecification();
        NeoFormConfigConfigurationSpecV2 neoFormConfig = definition.getNeoFormConfig();
        Minecraft minecraftExtension = (Minecraft)spec.getProject().getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        MinecraftArtifactCache artifactCacheExtension = (MinecraftArtifactCache)spec.getProject().getExtensions().getByType(MinecraftArtifactCache.class);
        File minecraftCache = ((Directory)artifactCacheExtension.getCacheDirectory().get()).getAsFile();
        File neoFormDirectory = ((Directory)spec.getProject().getLayout().getBuildDirectory().dir(String.format("neoForm/%s", spec.getIdentifier())).get()).getAsFile();
        File stepsMcpDirectory = new File(neoFormDirectory, "steps");
        HashMap versionData = Maps.newHashMap((Map)((Map)mappingsExtension.getVersion().get()));
        versionData.put("minecraft", spec.getMinecraftVersion());
        versionData.put("neoFormVersion", spec.getVersionedName());
        definition.setMappingVersionData(versionData);
        Map<String, String> symbolicDataSources = NeoFormRuntimeExtension.buildDataFilesMap(neoFormConfig, spec.getDistribution());
        ArrayList<NeoFormConfigConfigurationSpecV1.Step> steps = new ArrayList<NeoFormConfigConfigurationSpecV1.Step>(neoFormConfig.getSteps(spec.getDistribution().getName()));
        if (steps.isEmpty()) {
            throw new IllegalArgumentException("Unknown side: " + String.valueOf(spec.getDistribution()) + " for NeoForm " + ((NeoFormRuntimeSpecification)definition.getSpecification()).getNeoFormVersion());
        }
        steps.removeIf(step -> DISABLED_STEPS.contains(step.getType()));
        LinkedHashMap taskOutputs = definition.getTasks();
        for (NeoFormConfigConfigurationSpecV1.Step step2 : steps) {
            TaskProvider neoFormRuntimeTaskProvider;
            Optional<TaskProvider<? extends WithOutput>> adaptedInput = Optional.empty();
            if (spec.getPreTaskTypeAdapters().containsKey((Object)step2.getName())) {
                adaptedInput = NeoFormRuntimeExtension.adaptPreTaskInput(definition, step2, spec, taskOutputs, neoFormDirectory, symbolicDataSources, adaptedInput);
            }
            if ((neoFormRuntimeTaskProvider = NeoFormRuntimeExtension.createBuiltIn(spec, definition, neoFormConfig, step2, taskOutputs, definition.getGameArtifactProvidingTasks(), artifactCacheExtension, adaptedInput)) == null) {
                NeoFormConfigConfigurationSpecV1.Function function = neoFormConfig.getFunction(step2.getType());
                if (function == null) {
                    throw new IllegalArgumentException(String.format("Invalid MCP Config, Unknown function step type: %s File: %s", step2.getType(), neoFormConfig));
                }
                neoFormRuntimeTaskProvider = this.createExecute(spec, step2, function);
                if (step2.getType().equals("mergeMappings")) {
                    neoFormRuntimeTaskProvider.configure(tsk -> tsk.getOutputFileName().set((Object)"outputs.tsrg"));
                }
            }
            Optional<TaskProvider<? extends WithOutput>> finalAdaptedInput = adaptedInput;
            neoFormRuntimeTaskProvider.configure(neoFormRuntimeTask -> {
                if (neoFormRuntimeTask instanceof Runtime) {
                    Runtime runtimeTask = (Runtime)neoFormRuntimeTask;
                    NeoFormRuntimeExtension.configureMcpRuntimeTaskWithDefaults(spec, neoFormDirectory, symbolicDataSources, taskOutputs, step2, runtimeTask, finalAdaptedInput);
                }
            });
            String taskName = neoFormRuntimeTaskProvider.getName();
            if (!spec.getPostTypeAdapters().containsKey((Object)step2.getName())) {
                taskOutputs.put(taskName, neoFormRuntimeTaskProvider);
                continue;
            }
            for (TaskTreeAdapter taskTreeAdapter : spec.getPostTypeAdapters().get((Object)step2.getName())) {
                TaskProvider taskProvider = taskTreeAdapter.adapt((Definition)definition, neoFormRuntimeTaskProvider, neoFormDirectory, definition.getGameArtifactProvidingTasks(), definition.getMappingVersionData(), dependentTaskProvider -> dependentTaskProvider.configure(task -> NeoFormRuntimeExtension.configureMcpRuntimeTaskWithDefaults(spec, neoFormDirectory, symbolicDataSources, task)));
                if (taskProvider == null) continue;
                taskProvider.configure(task -> NeoFormRuntimeExtension.configureMcpRuntimeTaskWithDefaults(spec, neoFormDirectory, symbolicDataSources, task));
                neoFormRuntimeTaskProvider = taskProvider;
            }
            taskOutputs.put(taskName, neoFormRuntimeTaskProvider);
            taskOutputs.put(neoFormRuntimeTaskProvider.getName(), neoFormRuntimeTaskProvider);
        }
        TaskProvider lastTask = (TaskProvider)Iterators.getLast(taskOutputs.values().iterator());
        HashSet additionalRuntimeTasks = Sets.newHashSet();
        TaskProvider<? extends WithOutput> recompileInput = NeoFormRuntimeExtension.adaptPreTaskInput(definition, "recompile", spec, neoFormDirectory, symbolicDataSources, Optional.of(lastTask), Optional.of(lastTask)).orElseThrow(() -> new IllegalStateException("No input for recompile task due to pre-task adapters"));
        FileCollection recompileDependencies = definition.getAdditionalRecompileDependencies().plus((FileCollection)spec.getProject().files(new Object[]{definition.getMinecraftDependenciesConfiguration()}));
        TaskProvider recompileTask = NeoFormRuntimeExtension.createRecompileTask((CommonRuntimeDefinition)definition, recompileInput, (FileCollection)recompileDependencies, task -> task.configure(neoFormRuntimeTask -> NeoFormRuntimeExtension.configureMcpRuntimeTaskWithDefaults(spec, neoFormDirectory, symbolicDataSources, neoFormRuntimeTask)));
        taskOutputs.put(recompileTask.getName(), recompileTask);
        definition.getSourceJarTask().configure(task -> ((InputFileSpecification)task).getInput().set(recompileInput.flatMap(OutputSpecification::getOutput)));
        definition.getRawJarTask().configure(task -> ((InputFileSpecification)task).getInput().set(recompileTask.flatMap(OutputSpecification::getOutput)));
    }

    private static Optional<TaskProvider<? extends WithOutput>> adaptPreTaskInput(NeoFormRuntimeDefinition definition, NeoFormConfigConfigurationSpecV1.Step step, NeoFormRuntimeSpecification spec, LinkedHashMap<String, TaskProvider<? extends WithOutput>> taskOutputs, File neoFormDirectory, Map<String, String> symbolicDataSources, Optional<TaskProvider<? extends WithOutput>> adaptedInput) {
        String inputArgumentMarker = step.getValue("input");
        if (inputArgumentMarker == null) {
            throw new IllegalStateException("Can not change input chain on: " + step.getName() + " it has no input to transform!");
        }
        Optional<TaskProvider<? extends WithOutput>> inputTask = NeoFormRuntimeUtils.getInputTaskForTaskFrom(spec, inputArgumentMarker, taskOutputs);
        return NeoFormRuntimeExtension.adaptPreTaskInput(definition, step.getName(), spec, neoFormDirectory, symbolicDataSources, adaptedInput, inputTask);
    }

    private static Optional<TaskProvider<? extends WithOutput>> adaptPreTaskInput(NeoFormRuntimeDefinition definition, String stepName, NeoFormRuntimeSpecification spec, File neoFormDirectory, Map<String, String> symbolicDataSources, Optional<TaskProvider<? extends WithOutput>> adaptedInput, Optional<TaskProvider<? extends WithOutput>> inputTask) {
        if (!spec.getPreTaskTypeAdapters().get((Object)stepName).isEmpty() && inputTask.isPresent()) {
            for (TaskTreeAdapter taskTreeAdapter : spec.getPreTaskTypeAdapters().get((Object)stepName)) {
                TaskProvider modifiedTree = taskTreeAdapter.adapt((Definition)definition, (Provider)inputTask.get(), neoFormDirectory, definition.getGameArtifactProvidingTasks(), definition.getMappingVersionData(), taskProvider -> taskProvider.configure(task -> NeoFormRuntimeExtension.configureMcpRuntimeTaskWithDefaults(spec, neoFormDirectory, symbolicDataSources, task)));
                if (modifiedTree == null) continue;
                modifiedTree.configure(task -> NeoFormRuntimeExtension.configureMcpRuntimeTaskWithDefaults(spec, neoFormDirectory, symbolicDataSources, task));
                inputTask = Optional.of(modifiedTree);
            }
            adaptedInput = inputTask;
        }
        return adaptedInput;
    }
}

