/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;

public class NeoFormAccessTransformerUtils {
    private NeoFormAccessTransformerUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: McpAccessTransformerUtils. This is a utility class");
    }

    public static TaskTreeAdapter createAccessTransformerAdapter(Project project) {
        Minecraft minecraftExtension = (Minecraft)project.getExtensions().getByType(Minecraft.class);
        AccessTransformers accessTransformerFiles = minecraftExtension.getAccessTransformers();
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            if (accessTransformerFiles.getFiles().isEmpty() && ((List)accessTransformerFiles.getEntries().get()).isEmpty()) {
                return null;
            }
            TaskProvider accessTransformerTask = CommonRuntimeTaskUtils.createAccessTransformer((Definition)definition, (String)"User", (File)runtimeWorkspace, (Consumer)dependentTaskConfigurationHandler, new ArrayList(accessTransformerFiles.getFiles().getFiles().stream().filter(File::exists).collect(Collectors.toSet())), (Collection)((Collection)accessTransformerFiles.getEntries().get()));
            accessTransformerTask.configure(task -> task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
            accessTransformerTask.configure(task -> task.dependsOn(new Object[]{previousTasksOutput}));
            return accessTransformerTask;
        };
    }
}

