/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.naming;

import java.io.File;
import java.util.Objects;
import java.util.Optional;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import net.neoforged.gradle.common.runtime.definition.IDelegatingRuntimeDefinition;
import net.neoforged.gradle.common.runtime.naming.renamer.IMappingFileSourceRenamer;
import net.neoforged.gradle.common.runtime.naming.tasks.ApplyMappingsToSourceJar;
import net.neoforged.gradle.common.runtime.naming.tasks.ApplyOfficialMappingsToCompiledJar;
import net.neoforged.gradle.common.tasks.WriteIMappingsFile;
import net.neoforged.gradle.common.util.CacheableIMappingFile;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.naming.ApplyMappingsToCompiledJarTaskBuilder;
import net.neoforged.gradle.dsl.common.runtime.naming.ApplyMappingsToSourceJarTaskBuilder;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.runtime.naming.TaskBuildingContext;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.util.IMappingFileUtils;
import net.neoforged.gradle.util.TransformerUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class NeoFormOfficialNamingChannelConfigurator {
    private static final NeoFormOfficialNamingChannelConfigurator INSTANCE = new NeoFormOfficialNamingChannelConfigurator();

    private NeoFormOfficialNamingChannelConfigurator() {
    }

    public static NeoFormOfficialNamingChannelConfigurator getInstance() {
        return INSTANCE;
    }

    public void configure(Project project) {
        Minecraft minecraftExtension = (Minecraft)project.getExtensions().getByType(Minecraft.class);
        NamingChannel namingChannel = (NamingChannel)minecraftExtension.getNamingChannels().getByName("official");
        minecraftExtension.getNamingChannels().remove((Object)namingChannel);
        minecraftExtension.getNamingChannels().register("official", newOfficialProvider -> {
            newOfficialProvider.getApplySourceMappingsTaskBuilder().convention(context -> this.adaptApplySourceMappingsTask(context, namingChannel));
            newOfficialProvider.getApplyCompiledMappingsTaskBuilder().convention(context -> this.adaptApplyCompiledMappingsTask(context, namingChannel));
            newOfficialProvider.getHasAcceptedLicense().convention((Provider)namingChannel.getHasAcceptedLicense());
            newOfficialProvider.getLicenseText().convention((Provider)namingChannel.getLicenseText());
        });
        minecraftExtension.getMappings().getChannel().convention((Provider)minecraftExtension.getNamingChannels().named("official"));
    }

    @NotNull
    private TaskProvider<? extends Runtime> adaptApplySourceMappingsTask(@NotNull TaskBuildingContext context, @NotNull NamingChannel namingChannel) {
        TaskProvider applySourceMappingsTask = ((ApplyMappingsToSourceJarTaskBuilder)namingChannel.getApplySourceMappingsTaskBuilder().get()).build(context);
        Optional<NeoFormRuntimeDefinition> runtimeDefinition = context.getRuntimeDefinition().filter(NeoFormRuntimeDefinition.class::isInstance).map(NeoFormRuntimeDefinition.class::cast);
        if (!runtimeDefinition.isPresent()) {
            runtimeDefinition = context.getRuntimeDefinition().filter(IDelegatingRuntimeDefinition.class::isInstance).map(IDelegatingRuntimeDefinition.class::cast).map(IDelegatingRuntimeDefinition::getDelegate).filter(NeoFormRuntimeDefinition.class::isInstance).map(NeoFormRuntimeDefinition.class::cast);
        }
        if (!runtimeDefinition.isPresent()) {
            throw new IllegalStateException("The runtime definition is not present.");
        }
        NeoFormRuntimeDefinition mcpRuntimeDefinition = runtimeDefinition.get();
        String mappingsFilePath = mcpRuntimeDefinition.getNeoFormConfig().getData(new String[]{"mappings"});
        File mappingsFile = new File(mcpRuntimeDefinition.getUnpackedNeoFormZipDirectory(), Objects.requireNonNull(mappingsFilePath));
        applySourceMappingsTask.configure(task -> {
            if (task instanceof ApplyMappingsToSourceJar) {
                ApplyMappingsToSourceJar applyMappingsToSourceJar = (ApplyMappingsToSourceJar)task;
                applyMappingsToSourceJar.getSourceRenamer().set(context.getClientMappings().flatMap(OutputSpecification::getOutput).flatMap(clientMappings -> context.getServerMappings().flatMap(OutputSpecification::getOutput).map(TransformerUtils.guard(serverMappings -> {
                    IMappingFile clientMappingFile = IMappingFile.load((File)clientMappings.getAsFile()).reverse();
                    IMappingFile serverMappingFile = IMappingFile.load((File)serverMappings.getAsFile()).reverse();
                    IMappingFile mcpConfigMappings = IMappingFile.load((File)mappingsFile);
                    IMappingFile reversedMcpConfigMappings = mcpConfigMappings.reverse();
                    return IMappingFileSourceRenamer.from((IMappingFile)reversedMcpConfigMappings.chain(clientMappingFile).reverse(), (IMappingFile)reversedMcpConfigMappings.chain(serverMappingFile).reverse());
                }))));
            }
        });
        return applySourceMappingsTask;
    }

    @NotNull
    private TaskProvider<? extends Runtime> adaptApplyCompiledMappingsTask(@NotNull TaskBuildingContext context, @NotNull NamingChannel namingChannel) {
        TaskProvider applyCompiledMappingsTask = ((ApplyMappingsToCompiledJarTaskBuilder)namingChannel.getApplyCompiledMappingsTaskBuilder().get()).build(context);
        TaskProvider<? extends Runtime> combineMappingsTask = NeoFormOfficialNamingChannelConfigurator.createCombinedMappingsFor(context);
        applyCompiledMappingsTask.configure(task -> {
            if (task instanceof ApplyOfficialMappingsToCompiledJar) {
                ApplyOfficialMappingsToCompiledJar applyMappingsToCompiledJar = (ApplyOfficialMappingsToCompiledJar)task;
                applyMappingsToCompiledJar.getMappings().set(combineMappingsTask.flatMap(OutputSpecification::getOutput));
                applyMappingsToCompiledJar.getShouldReverseMappings().set((Object)false);
                applyMappingsToCompiledJar.dependsOn(new Object[]{combineMappingsTask});
            }
        });
        return applyCompiledMappingsTask;
    }

    @NotNull
    private static TaskProvider<? extends Runtime> createCombinedMappingsFor(@NotNull TaskBuildingContext context) {
        Optional<NeoFormRuntimeDefinition> runtimeDefinition = context.getRuntimeDefinition().filter(NeoFormRuntimeDefinition.class::isInstance).map(NeoFormRuntimeDefinition.class::cast);
        if (!runtimeDefinition.isPresent()) {
            runtimeDefinition = context.getRuntimeDefinition().filter(IDelegatingRuntimeDefinition.class::isInstance).map(IDelegatingRuntimeDefinition.class::cast).map(IDelegatingRuntimeDefinition::getDelegate).filter(NeoFormRuntimeDefinition.class::isInstance).map(NeoFormRuntimeDefinition.class::cast);
        }
        if (!runtimeDefinition.isPresent()) {
            throw new IllegalStateException("The runtime definition is not present.");
        }
        NeoFormRuntimeDefinition neoformRuntimeDefinition = runtimeDefinition.get();
        String mappingsFilePath = neoformRuntimeDefinition.getNeoFormConfig().getData(new String[]{"mappings"});
        File mappingsFile = new File(neoformRuntimeDefinition.getUnpackedNeoFormZipDirectory(), Objects.requireNonNull(mappingsFilePath));
        TaskProvider reverseMappingsTask = context.getProject().getTasks().register((String)context.getTaskNameBuilder().apply(String.format("combineMappingsFor%s", StringUtils.capitalize((String)context.getEnvironmentName()))), WriteIMappingsFile.class, task -> task.getMappings().set(context.getClientMappings().flatMap(OutputSpecification::getOutput).map(TransformerUtils.guard(clientMappingsFile -> {
            IMappingFile neoformConfigMappings = IMappingFile.load((File)mappingsFile);
            IMappingFile clientMappingFile = IMappingFileUtils.load((File)clientMappingsFile.getAsFile()).reverse();
            return new CacheableIMappingFile(neoformConfigMappings.rename(NeoFormOfficialNamingChannelConfigurator.makeRenamer(clientMappingFile, true, true, true, false)));
        }))));
        context.addTask(reverseMappingsTask);
        return reverseMappingsTask;
    }

    private static IRenamer makeRenamer(final IMappingFile link, final boolean classes, final boolean fields, final boolean methods, final boolean params) {
        return new IRenamer(){

            public String rename(IMappingFile.IPackage value) {
                return link.remapPackage(value.getOriginal());
            }

            public String rename(IMappingFile.IClass value) {
                return classes ? link.remapClass(value.getOriginal()) : value.getMapped();
            }

            public String rename(IMappingFile.IField value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getOriginal());
                return cls == null || !fields ? value.getMapped() : cls.remapField(value.getOriginal());
            }

            public String rename(IMappingFile.IMethod value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getOriginal());
                return cls == null || !methods ? value.getMapped() : cls.remapMethod(value.getOriginal(), value.getDescriptor());
            }

            public String rename(IMappingFile.IParameter value) {
                IMappingFile.IMethod mtd = (IMappingFile.IMethod)value.getParent();
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)mtd.getParent()).getOriginal());
                mtd = cls == null ? null : cls.getMethod(mtd.getOriginal(), mtd.getDescriptor());
                return mtd == null || !params ? value.getMapped() : mtd.remapParameter(value.getIndex(), value.getMapped());
            }
        };
    }
}

