/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.dependency;

import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementResult;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.util.NeoFormRuntimeUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;

public final class NeoFormDependencyManager {
    private static final NeoFormDependencyManager INSTANCE = new NeoFormDependencyManager();

    private NeoFormDependencyManager() {
    }

    public static NeoFormDependencyManager getInstance() {
        return INSTANCE;
    }

    public void apply(Project project) {
        DependencyReplacement dependencyReplacer = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacer.getReplacementHandlers().create("neoForm", handler -> handler.getReplacer().set(context -> {
            if (this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                return Optional.empty();
            }
            if (!(context.getDependency() instanceof ExternalModuleDependency)) {
                return Optional.empty();
            }
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)context.getDependency();
            NeoFormRuntimeDefinition runtimeDefinition = NeoFormDependencyManager.buildNeoFormRuntimeFromDependency(project, externalModuleDependency);
            return Optional.of(new DependencyReplacementResult(project, Optional.of(ConfigurationUtils.findReplacementConfigurations((Project)project, (Configuration)context.getConfiguration())), name -> CommonRuntimeUtils.buildTaskName((Definition)runtimeDefinition, (String)name), runtimeDefinition.getSourceJarTask(), runtimeDefinition.getRawJarTask(), runtimeDefinition.getMinecraftDependenciesConfiguration(), builder -> builder.setVersion(((NeoFormRuntimeSpecification)runtimeDefinition.getSpecification()).getNeoFormArtifact().getVersion()), builder -> builder.setVersion(((NeoFormRuntimeSpecification)runtimeDefinition.getSpecification()).getNeoFormArtifact().getVersion()), arg_0 -> ((NeoFormRuntimeDefinition)runtimeDefinition).setReplacedDependency(arg_0), arg_0 -> ((NeoFormRuntimeDefinition)runtimeDefinition).onRepoWritten(arg_0), Sets::newHashSet));
        }));
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return externalModuleDependency.getGroup() == null || !externalModuleDependency.getGroup().equals("net.minecraft") || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equalsIgnoreCase("neoform_client") || dependency.getName().equalsIgnoreCase("neoform_server") || dependency.getName().equalsIgnoreCase("neoform_joined");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().isEmpty()) {
            return true;
        }
        return NeoFormDependencyManager.hasSourcesArtifact(externalModuleDependency);
    }

    private static boolean hasSourcesArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return Objects.equals(artifact.getClassifier(), "sources") && Objects.equals(artifact.getExtension(), "jar");
    }

    private static NeoFormRuntimeDefinition buildNeoFormRuntimeFromDependency(Project project, ExternalModuleDependency dependency) {
        NeoFormRuntimeExtension runtimeExtension = (NeoFormRuntimeExtension)((Object)project.getExtensions().getByType(NeoFormRuntimeExtension.class));
        return (NeoFormRuntimeDefinition)runtimeExtension.maybeCreate(builder -> {
            builder.withDistributionType(DistributionType.valueOf((String)dependency.getName().toLowerCase().replace("neoform_", "").toUpperCase(Locale.ROOT)));
            if (dependency.getVersion() == null) {
                throw new IllegalStateException("Version is not defined on NeoForm dependency");
            }
            builder.withNeoFormVersion(dependency.getVersion());
            NeoFormRuntimeUtils.configureDefaultRuntimeSpecBuilder(project, builder);
        });
    }
}

