/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.util.FileUtils;
import net.neoforged.gradle.util.TransformerUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class StripJar
extends DefaultRuntime {
    public StripJar() {
        this.getMappingsFile().fileProvider(this.getRuntimeData().flatMap(data -> (Provider)data.get("mappings")));
        this.getIsWhitelistMode().convention((Object)true);
        this.getFilters().convention(this.getMappingsFile().map(TransformerUtils.guardWithResource(lines -> lines.filter(l -> !l.startsWith("\t")).map(s -> s.split(" ")[0] + ".class").collect(Collectors.toSet()), file -> FileUtils.readAllLines((Path)file.getAsFile().toPath()))));
        this.getMappingsFile().finalizeValueOnRead();
        this.getIsWhitelistMode().finalizeValueOnRead();
        this.getFilters().finalizeValueOnRead();
    }

    @TaskAction
    protected void run() throws Throwable {
        File input = ((RegularFile)this.getInput().get()).getAsFile();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        boolean isWhitelist = (Boolean)this.getIsWhitelistMode().get();
        this.strip(input, output, isWhitelist);
    }

    private void strip(File input, File output, boolean whitelist) throws IOException {
        try (JarInputStream is = new JarInputStream(new FileInputStream(input));
             FileOutputStream fout = new FileOutputStream(output);
             JarOutputStream os = new JarOutputStream(fout);){
            JarEntry entry;
            while ((entry = is.getNextJarEntry()) != null) {
                if (!this.isEntryValid(entry, whitelist)) continue;
                os.putNextEntry(entry);
                IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                os.closeEntry();
            }
        }
    }

    private boolean isEntryValid(JarEntry entry, boolean whitelist) {
        return !entry.isDirectory() && ((List)this.getFilters().get()).contains(entry.getName()) == whitelist;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getMappingsFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @Input
    public abstract ListProperty<String> getFilters();

    @Input
    public abstract Property<Boolean> getIsWhitelistMode();
}

