/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion;
import net.neoforged.gradle.neoform.runtime.tasks.AbstractInjectSource;
import net.neoforged.gradle.neoform.runtime.tasks.InjectFromDirectorySource;
import net.neoforged.gradle.neoform.runtime.tasks.InjectFromZipSource;
import net.neoforged.gradle.util.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.Nullable;

@CacheableTask
public abstract class InjectZipContent
extends DefaultRuntime {
    private final CacheableMinecraftVersion minimalSupportedVersion = CacheableMinecraftVersion.from((String)"1.14.4", (Project)this.getProject());

    @TaskAction
    public void run() throws Exception {
        RegularFileProperty inputZipFile = this.getInjectionSource();
        File outputFile = this.ensureFileWorkspaceReady(this.getOutput());
        this.injectCode(((RegularFile)inputZipFile.get()).getAsFile(), outputFile);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInjectionSource();

    @Nested
    public abstract ListProperty<AbstractInjectSource> getInjectedSources();

    private void injectCode(File inputZipFile, File outputZipFile) throws IOException {
        List injectedSources = (List)this.getInjectedSources().get();
        String packageInfoTemplateContent = this.findPackageInfoTemplate(injectedSources);
        try (FileOutputStream fileOut = new FileOutputStream(outputZipFile);
             ZipOutputStream zos = new ZipOutputStream(fileOut);){
            this.copyInputZipContent(inputZipFile, zos, packageInfoTemplateContent);
            for (AbstractInjectSource injectedSource : injectedSources) {
                injectedSource.copyTo(zos);
            }
        }
    }

    @Nullable
    private String findPackageInfoTemplate(List<AbstractInjectSource> injectedSources) throws IOException {
        for (AbstractInjectSource injectedSource : injectedSources) {
            byte[] content = injectedSource.tryReadFile("package-info-template.java");
            if (content == null) continue;
            return new String(content, StandardCharsets.UTF_8);
        }
        return null;
    }

    private void copyInputZipContent(File inputZipFile, ZipOutputStream zos, @Nullable String packageInfoTemplateContent) throws IOException {
        HashSet<String> visited = new HashSet<String>();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(inputZipFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String pkg;
                zos.putNextEntry(entry);
                IOUtils.copyLarge((InputStream)zis, (OutputStream)zos);
                zos.closeEntry();
                if (packageInfoTemplateContent == null || !visited.add(pkg = entry.isDirectory() && !entry.getName().endsWith("/") ? entry.getName() : (entry.getName().indexOf(47) == -1 ? "" : entry.getName().substring(0, entry.getName().lastIndexOf(47)))) || !pkg.startsWith("net/minecraft/") && (!pkg.startsWith("com/mojang/") || ((CacheableMinecraftVersion)this.getMinecraftVersion().get()).compareTo(this.minimalSupportedVersion) <= 0)) continue;
                zos.putNextEntry(FileUtils.getStableEntry((String)(pkg + "/package-info.java")));
                zos.write(packageInfoTemplateContent.replace("{PACKAGE}", pkg.replaceAll("/", ".")).getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
            }
        }
    }

    public void injectZip(Provider<File> zipFile) {
        this.injectZip(zipFile, filter -> {});
    }

    public void injectZip(Provider<File> zipFile, Consumer<PatternFilterable> filter) {
        InjectFromZipSource zipInject = (InjectFromZipSource)this.getProject().getObjects().newInstance(InjectFromZipSource.class, new Object[0]);
        zipInject.getZipFile().fileProvider(zipFile);
        this.addSource(zipInject, filter);
    }

    public void injectDirectory(Provider<File> directory) {
        this.injectDirectory(directory, filter -> {});
    }

    public void injectDirectory(Provider<File> directory, Consumer<PatternFilterable> filter) {
        InjectFromDirectorySource zipInject = (InjectFromDirectorySource)this.getProject().getObjects().newInstance(InjectFromDirectorySource.class, new Object[0]);
        zipInject.getDirectory().fileProvider(directory);
        this.addSource(zipInject, filter);
    }

    private void addSource(AbstractInjectSource zipInject, Consumer<PatternFilterable> filter) {
        Provider patternProvider = this.getProject().provider(() -> {
            PatternSet patternSet = new PatternSet();
            filter.accept((PatternFilterable)patternSet);
            return patternSet;
        });
        zipInject.getInclusionFilter().set(patternProvider.map(pf -> pf.getIncludes().stream().sorted().collect(Collectors.toList())));
        zipInject.getExclusionFilter().set(patternProvider.map(pf -> pf.getExcludes().stream().sorted().collect(Collectors.toList())));
        this.getInjectedSources().add((Object)zipInject);
    }
}

