/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.naming.renamer;

import de.siegmar.fastcsv.reader.NamedCsvReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.gradle.common.runtime.naming.renamer.RegexBasedSourceRenamer;
import org.gradle.api.tasks.Nested;

public class NeoFormSourceRenamer
extends RegexBasedSourceRenamer {
    private final Map<String, String> names;
    private final Map<String, String> docs;

    public static NeoFormSourceRenamer from(File data) throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> docs = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(data);){
            List entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).collect(Collectors.toList());
            for (ZipEntry entry : entries) {
                NamedCsvReader reader = NamedCsvReader.builder().build((Reader)new InputStreamReader(zip.getInputStream(entry)));
                Throwable throwable = null;
                try {
                    String obf = reader.getHeader().contains("searge") ? "searge" : "param";
                    boolean hasDesc = reader.getHeader().contains("desc");
                    reader.forEach(row -> {
                        String desc;
                        String searge = row.getField(obf);
                        names.put(searge, row.getField("name"));
                        if (hasDesc && !(desc = row.getField("desc")).isEmpty()) {
                            docs.put(searge, desc);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        return new NeoFormSourceRenamer(names, docs);
    }

    private NeoFormSourceRenamer(Map<String, String> names, Map<String, String> docs) {
        this.names = names;
        this.docs = docs;
    }

    @Nested
    public Map<String, String> getNames() {
        return this.names;
    }

    @Nested
    public Map<String, String> getDocs() {
        return this.docs;
    }
}

