/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.specification;

import com.google.common.collect.Multimap;
import java.util.Objects;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.Artifact;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.neoform.runtime.specification.NeoFormSpecification;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;

public class NeoFormRuntimeSpecification
extends CommonRuntimeSpecification
implements NeoFormSpecification {
    private final Artifact neoFormArtifact;
    private final FileCollection additionalRecompileDependencies;

    public NeoFormRuntimeSpecification(Project project, String version, Artifact neoFormArtifact, DistributionType side, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, FileCollection additionalRecompileDependencies) {
        super(project, "neoForm", version, side, preTaskTypeAdapters, postTypeAdapters, NeoFormRuntimeExtension.class);
        this.neoFormArtifact = neoFormArtifact;
        this.additionalRecompileDependencies = additionalRecompileDependencies;
    }

    public String getMinecraftVersion() {
        return this.getNeoFormArtifact().getVersion().substring(0, this.getNeoFormArtifact().getVersion().lastIndexOf("-"));
    }

    public String getNeoFormVersion() {
        return this.getNeoFormArtifact().getVersion().substring(this.getNeoFormArtifact().getVersion().lastIndexOf("-") + 1);
    }

    public Artifact getNeoFormArtifact() {
        return this.neoFormArtifact;
    }

    public FileCollection getAdditionalRecompileDependencies() {
        return this.additionalRecompileDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoFormRuntimeSpecification)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NeoFormRuntimeSpecification spec = (NeoFormRuntimeSpecification)((Object)o);
        if (!this.neoFormArtifact.equals((Object)spec.neoFormArtifact)) {
            return false;
        }
        return this.additionalRecompileDependencies.equals(spec.additionalRecompileDependencies);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.neoFormArtifact.hashCode();
        result = 31 * result + this.additionalRecompileDependencies.hashCode();
        return result;
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<NeoFormRuntimeSpecification, Builder>
    implements NeoFormSpecification.Builder<NeoFormRuntimeSpecification, Builder> {
        private Provider<String> neoFormGroup;
        private Provider<String> neoFormName;
        private Provider<String> neoFormVersion;
        private Provider<Artifact> neoFormArtifact;
        private FileCollection additionalDependencies;

        private Builder(Project project) {
            super(project);
            this.additionalDependencies = project.getObjects().fileCollection();
            this.neoFormGroup = project.provider(() -> "net.neoforged");
            this.neoFormName = project.provider(() -> "neoform");
            this.neoFormVersion = project.provider(() -> "+");
            this.neoFormArtifact = this.neoFormGroup.flatMap(group -> this.neoFormName.flatMap(name -> this.neoFormVersion.map(version -> Artifact.from((String)String.format("%s:%s:%s@zip", group, name, version)))));
        }

        protected Builder getThis() {
            return this;
        }

        public static Builder from(Project project) {
            return new Builder(project);
        }

        public Builder withNeoFormGroup(Provider<String> neoFormGroup) {
            this.neoFormGroup = neoFormGroup;
            return this.getThis();
        }

        public Builder withNeoFormGroup(String neoFormGroup) {
            if (neoFormGroup == null) {
                return this.getThis();
            }
            return this.withNeoFormGroup(this.project.provider(() -> neoFormGroup));
        }

        public Builder withNeoFormName(Provider<String> neoFormName) {
            this.neoFormName = neoFormName;
            return this.getThis();
        }

        public Builder withNeoFormName(String neoFormName) {
            if (neoFormName == null) {
                return this.getThis();
            }
            return this.withNeoFormName(this.project.provider(() -> neoFormName));
        }

        public Builder withNeoFormVersion(Provider<String> neoFormVersion) {
            this.neoFormVersion = neoFormVersion;
            return this.getThis();
        }

        public Builder withNeoFormVersion(String neoFormVersion) {
            if (neoFormVersion == null) {
                return this.getThis();
            }
            return this.withNeoFormVersion(this.project.provider(() -> neoFormVersion));
        }

        public Builder withNeoFormArtifact(Provider<Artifact> neoFormArtifact) {
            this.neoFormArtifact = neoFormArtifact;
            return this.getThis();
        }

        public Builder withNeoFormArtifact(Artifact neoFormArtifact) {
            if (neoFormArtifact == null) {
                return this.getThis();
            }
            return this.withNeoFormArtifact(this.project.provider(() -> neoFormArtifact));
        }

        public Builder withAdditionalDependencies(FileCollection files) {
            this.additionalDependencies = this.additionalDependencies.plus(files);
            return this.getThis();
        }

        public NeoFormRuntimeSpecification build() {
            Provider resolvedArtifact = this.neoFormArtifact.map(a -> Builder.resolveNeoFormVersion(this.project, a));
            Provider resolvedVersion = resolvedArtifact.map(Artifact::getVersion).map(v -> v.equals("+") ? "" : v);
            return new NeoFormRuntimeSpecification(this.project, (String)resolvedVersion.get(), (Artifact)resolvedArtifact.get(), (DistributionType)this.distributionType.get(), (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, this.additionalDependencies);
        }

        private static Artifact resolveNeoFormVersion(Project project, Artifact current) {
            if (!Objects.equals(current.getVersion(), "+")) {
                return current;
            }
            Configuration resolveConfig = ConfigurationUtils.temporaryConfiguration((Project)project, (Dependency[])new Dependency[]{current.toDependency(project)});
            return resolveConfig.getResolvedConfiguration().getResolvedArtifacts().stream().filter(current.asArtifactMatcher()).findFirst().map(Artifact::from).orElse(current);
        }
    }
}

