/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion;
import net.neoforged.gradle.util.FileUtils;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class InjectCode
extends DefaultRuntime {
    private final CacheableMinecraftVersion minimalSupportedVersion = CacheableMinecraftVersion.from((String)"1.14.4", (Project)this.getProject());

    public InjectCode() {
        this.getInjectionDirectory().fileProvider(this.getRuntimeData().flatMap(data -> (Provider)data.get("inject")));
    }

    @TaskAction
    public void run() throws Exception {
        RegularFileProperty inputZipFile = this.getInjectionSource();
        File outputFile = this.ensureFileWorkspaceReady(this.getOutput());
        Directory injectionDirectory = (Directory)this.getInjectionDirectory().get();
        RegularFile packageInfoTemplate = injectionDirectory.file("package-info-template.java");
        String packageInfoTemplateContent = packageInfoTemplate.getAsFile().exists() ? FileUtils.readAllLines((Path)packageInfoTemplate.getAsFile().toPath()).collect(Collectors.joining("\n")) : null;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(((RegularFile)inputZipFile.get()).getAsFile()));
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputFile));){
            ZipEntry entry;
            HashSet<String> visited = new HashSet<String>();
            while ((entry = zis.getNextEntry()) != null) {
                String pkg;
                zos.putNextEntry(entry);
                IOUtils.copyLarge((InputStream)zis, (OutputStream)zos);
                zos.closeEntry();
                if (packageInfoTemplateContent == null || !visited.add(pkg = entry.isDirectory() && !entry.getName().endsWith("/") ? entry.getName() : (entry.getName().indexOf(47) == -1 ? "" : entry.getName().substring(0, entry.getName().lastIndexOf(47)))) || !pkg.startsWith("net/minecraft/") && (!pkg.startsWith("com/mojang/") || ((CacheableMinecraftVersion)this.getMinecraftVersion().get()).compareTo(this.minimalSupportedVersion) <= 0)) continue;
                zos.putNextEntry(FileUtils.getStableEntry((String)(pkg + "/package-info.java")));
                zos.write(packageInfoTemplateContent.replace("{PACKAGE}", pkg.replaceAll("/", ".")).getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
            }
            this.getFilteredInjectionDirectory().visit((FileVisitor)new ZipBuildingFileTreeVisitor(zos));
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInjectionSource();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getInjectionDirectory();

    @Input
    @Optional
    public abstract ListProperty<String> getInclusionFilter();

    @Input
    @Optional
    public abstract ListProperty<String> getExclusionFilter();

    private FileTree getFilteredInjectionDirectory() {
        FileTree result = this.getInjectionDirectory().getAsFileTree();
        if (this.getInclusionFilter().isPresent() && !((List)this.getInclusionFilter().get()).isEmpty()) {
            result = result.matching(pattern -> pattern.include((Iterable)this.getInclusionFilter().get()));
        }
        if (this.getExclusionFilter().isPresent() && !((List)this.getExclusionFilter().get()).isEmpty()) {
            result = result.matching(pattern -> pattern.exclude((Iterable)this.getExclusionFilter().get()));
        }
        return result;
    }
}

