/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.Reader;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion;
import net.neoforged.gradle.neoform.runtime.tasks.DownloadFile;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class DownloadVersionJson
extends DownloadFile {
    public DownloadVersionJson() {
        this.getDownloadedManifest().finalizeValueOnRead();
    }

    @Override
    public void run() throws Exception {
        if (!this.getDownloadInfo().isPresent()) {
            Gson gson = new Gson();
            FileReader reader = new FileReader(((RegularFile)this.getDownloadedManifest().get()).getAsFile());
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            for (JsonElement e : json.getAsJsonArray("versions")) {
                String v = e.getAsJsonObject().get("id").getAsString();
                if (!v.equals(((CacheableMinecraftVersion)this.getMinecraftVersion().get()).toString())) continue;
                FileDownloadingUtils.DownloadInfo info = new FileDownloadingUtils.DownloadInfo(e.getAsJsonObject().get("url").getAsString(), null, "json", v, null);
                this.doDownloadFrom(info);
                return;
            }
            throw new IllegalStateException("Could not find the correct version json.");
        }
        super.run();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getDownloadedManifest();
}

