/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.FileReader;
import java.io.Reader;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import net.neoforged.gradle.neoform.runtime.tasks.DownloadFile;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class DownloadCore
extends DownloadFile {
    public DownloadCore() {
        this.getDownloadedVersionJson().finalizeValueOnRead();
        this.getArtifact().finalizeValueOnRead();
        this.getExtension().finalizeValueOnRead();
    }

    @Override
    public void run() throws Exception {
        if (!this.getDownloadInfo().isPresent()) {
            Gson gson = new Gson();
            FileReader reader = new FileReader(((RegularFile)this.getDownloadedVersionJson().get()).getAsFile());
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            JsonObject artifactInfo = json.getAsJsonObject("downloads").getAsJsonObject((String)this.getArtifact().get());
            String url = artifactInfo.get("url").getAsString();
            String hash = artifactInfo.get("sha1").getAsString();
            String version = json.getAsJsonObject().get("id").getAsString();
            FileDownloadingUtils.DownloadInfo info = new FileDownloadingUtils.DownloadInfo(url, hash, (String)this.getExtension().get(), version, (String)this.getArtifact().get());
            this.doDownloadFrom(info);
        } else {
            super.run();
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getDownloadedVersionJson();

    @Input
    public abstract Property<String> getArtifact();

    @Input
    public abstract Property<String> getExtension();
}

