/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.util.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class StripJar
extends DefaultRuntime {
    public StripJar() {
        this.getMappingsFiles().from(new Object[]{this.getRuntimeData().map(data -> (FileTree)data.get("mappings"))});
        this.getIsWhitelistMode().convention((Object)true);
        this.getFilters().convention(this.getProject().provider(() -> {
            if (this.getMappingsFiles().isEmpty()) {
                return null;
            }
            return this.getMappingsFiles().getFiles().stream().flatMap(file -> FileUtils.readAllLines((Path)file.toPath())).filter(l -> !l.startsWith("\t")).map(s -> s.split(" ")[0] + ".class").distinct().collect(Collectors.toList());
        }));
        this.getIsWhitelistMode().finalizeValueOnRead();
        this.getFilters().finalizeValueOnRead();
    }

    @TaskAction
    protected void run() throws Throwable {
        File input = ((RegularFile)this.getInput().get()).getAsFile();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        boolean isWhitelist = (Boolean)this.getIsWhitelistMode().get();
        this.strip(input, output, isWhitelist);
    }

    private void strip(File input, File output, boolean whitelist) throws IOException {
        try (JarInputStream is = new JarInputStream(new FileInputStream(input));
             FileOutputStream fout = new FileOutputStream(output);
             JarOutputStream os = new JarOutputStream(fout);){
            JarEntry entry;
            while ((entry = is.getNextJarEntry()) != null) {
                if (!this.isEntryValid(entry, whitelist)) continue;
                os.putNextEntry(entry);
                IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                os.closeEntry();
            }
        }
    }

    private boolean isEntryValid(JarEntry entry, boolean whitelist) {
        if (entry.isDirectory()) {
            return false;
        }
        if (this.getFilters().isPresent()) {
            return ((List)this.getFilters().get()).contains(entry.getName()) == whitelist;
        }
        return true;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract ConfigurableFileCollection getMappingsFiles();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @Input
    @Optional
    public abstract ListProperty<String> getFilters();

    @Input
    public abstract Property<Boolean> getIsWhitelistMode();
}

