/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.RuntimeArgumentsImpl;
import net.neoforged.gradle.common.runtime.tasks.RuntimeMultiArgumentsImpl;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeMultiArguments;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class RecompileSourceJar
extends JavaCompile
implements Runtime {
    private Property<JavaLanguageVersion> javaVersion;
    private Provider<JavaToolchainService> javaToolchainService;
    private final RuntimeArguments arguments = (RuntimeArguments)this.getObjectFactory().newInstance(RuntimeArgumentsImpl.class, new Object[]{this.getProviderFactory()});
    private final RuntimeMultiArguments multiArguments = (RuntimeMultiArguments)this.getObjectFactory().newInstance(RuntimeMultiArgumentsImpl.class, new Object[]{this.getProviderFactory()});

    public RecompileSourceJar() {
        this.javaVersion = this.getProject().getObjects().property(JavaLanguageVersion.class);
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class);
        this.javaToolchainService = this.getProviderFactory().provider(() -> service);
        this.getStepsDirectory().convention(this.getRuntimeDirectory().dir("steps"));
        this.getOutputDirectory().convention(this.getStepsDirectory().flatMap(d -> this.getStepName().map(arg_0 -> ((Directory)d).dir(arg_0))));
        this.getOutputFileName().convention(this.getArguments().getOrDefault("outputExtension", this.getProviderFactory().provider(() -> "jar")).map(extension -> String.format("output.%s", extension)));
        this.getOutput().convention(this.getOutputDirectory().flatMap(d -> this.getOutputFileName().map(arg_0 -> ((Directory)d).file(arg_0))));
        this.getJavaVersion().convention((Provider)((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        this.getJavaLauncher().convention(this.getJavaToolChain().flatMap(toolChain -> {
            if (!this.getJavaVersion().isPresent()) {
                return toolChain.launcherFor((JavaToolchainSpec)new CurrentJvmToolchainSpec(this.getObjectFactory()));
            }
            return toolChain.launcherFor(spec -> spec.getLanguageVersion().set(this.getJavaVersion()));
        }));
        this.setDescription("Recompiles an already existing decompiled java jar.");
        this.setSource(this.getProject().zipTree((Object)this.getInputJar()).matching(filter -> filter.include(new String[]{"**/*.java"})));
        this.setClasspath((FileCollection)this.getCompileClasspath());
        this.getOptions().setAnnotationProcessorPath((FileCollection)this.getAnnotationProcessorPath());
        this.getOptions().getGeneratedSourceOutputDirectory().convention(this.getOutputDirectory().map(directory -> directory.dir("generated/sources/annotationProcessor")));
        this.getOptions().getHeaderOutputDirectory().convention(this.getOutputDirectory().map(directory -> directory.dir("generated/sources/headers")));
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class);
        this.getModularity().getInferModulePath().convention((Provider)javaPluginExtension.getModularity().getInferModulePath());
        this.getJavaCompiler().convention(this.getJavaVersion().flatMap(javaVersion -> service.compilerFor(javaToolchainSpec -> javaToolchainSpec.getLanguageVersion().set(javaVersion))));
        this.getDestinationDirectory().set(this.getOutputDirectory().map(directory -> directory.dir("classes")));
        this.getOptions().setWarnings(false);
        this.getOptions().setVerbose(false);
        this.getOptions().setDeprecation(false);
        this.getOptions().setFork(true);
        this.getOptions().setIncremental(true);
        this.getOptions().getIncrementalAfterFailure().set((Object)true);
        this.getInputJar().finalizeValueOnRead();
    }

    @TaskAction
    protected void compile(InputChanges inputs) {
        super.compile(inputs);
        if (this.getState().getDidWork()) {
            File outputJar = this.ensureFileWorkspaceReady(this.getOutput());
            try (FileOutputStream fileOutputStream = new FileOutputStream(outputJar);
                 ZipOutputStream outputZipStream = new ZipOutputStream(fileOutputStream);){
                ZipBuildingFileTreeVisitor zipBuildingFileTreeVisitor = new ZipBuildingFileTreeVisitor(outputZipStream);
                this.getDestinationDirectory().getAsFileTree().visit((FileVisitor)zipBuildingFileTreeVisitor);
                this.getArchiveOperations().zipTree((Object)this.getInputJar()).matching(filter -> filter.exclude(new String[]{"**/*.java"})).visit((FileVisitor)zipBuildingFileTreeVisitor);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create recompiled output jar", e);
            }
        }
    }

    @Nested
    public RuntimeArguments getArguments() {
        return this.arguments;
    }

    @Nested
    public RuntimeMultiArguments getMultiArguments() {
        return this.multiArguments;
    }

    public String getGroup() {
        String name = (String)this.getRuntimeName().getOrElse((Object)"unknown");
        return String.format("NeoGradle/Runtime/%s", name);
    }

    @Internal
    public final Provider<JavaToolchainService> getJavaToolChain() {
        return this.javaToolchainService;
    }

    @Nested
    @Optional
    public Property<JavaLanguageVersion> getJavaVersion() {
        return this.javaVersion;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInputJar();

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getAnnotationProcessorPath();

    @InputFiles
    @Classpath
    public abstract ConfigurableFileCollection getCompileClasspath();

    public abstract ObjectFactory getObjectFactory();

    public abstract ProviderFactory getProviderFactory();
}

