/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LogLevel;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import java.io.File;
import java.io.OutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public abstract class Patch
extends DefaultRuntime {
    public Patch() {
        this.getRejectsFile().fileProvider(this.getFileInOutputDirectory("rejects.zip"));
        this.getIsVerbose().convention((Object)false);
    }

    @TaskAction
    public void run() throws Exception {
        boolean success;
        File input = ((RegularFile)this.getInput().get()).getAsFile();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        File rejects = ((RegularFile)this.getRejectsFile().get()).getAsFile();
        ExtractingAndRootCollectingVisitor patchArchiveLocator = new ExtractingAndRootCollectingVisitor();
        this.getPatchArchive().getAsFileTree().matching(filterable -> filterable.include(fileTreeElement -> (fileTreeElement.getPath() + "/").startsWith((String)this.getPatchDirectory().get()))).visit((FileVisitor)patchArchiveLocator);
        if (patchArchiveLocator.directory == null) {
            throw new RuntimeException("Patch directory not found.");
        }
        PatchOperation.Builder builder = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), org.gradle.api.logging.LogLevel.LIFECYCLE)).basePath(input.toPath()).patchesPath(patchArchiveLocator.directory.toPath()).outputPath(output.toPath()).level((Boolean)this.getIsVerbose().get() != false ? LogLevel.ALL : LogLevel.WARN).mode(PatchMode.OFFSET).rejectsPath(rejects.toPath());
        if (this.getPatchesModifiedPrefix().isPresent()) {
            builder = builder.bPrefix((String)this.getPatchesModifiedPrefix().get());
        }
        if (this.getPatchesOriginalPrefix().isPresent()) {
            builder = builder.aPrefix((String)this.getPatchesOriginalPrefix().get());
        }
        CliOperation.Result result = builder.build().operate();
        boolean bl = success = result.exit == 0;
        if (!success) {
            this.getProject().getLogger().error("Rejects saved to: {}", (Object)rejects);
            throw new RuntimeException("Patch failure.");
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getPatchArchive();

    @Input
    public abstract Property<String> getPatchDirectory();

    @OutputFile
    public abstract RegularFileProperty getRejectsFile();

    @Input
    public abstract Property<Boolean> getIsVerbose();

    @Input
    @Optional
    public abstract Property<String> getPatchesOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getPatchesModifiedPrefix();

    private static final class ExtractingAndRootCollectingVisitor
    implements FileVisitor {
        private File directory;

        private ExtractingAndRootCollectingVisitor() {
        }

        public void visitDir(@NotNull FileVisitDetails dirDetails) {
            if (this.directory == null) {
                this.directory = dirDetails.getFile();
            }
            dirDetails.getFile();
        }

        public void visitFile(@NotNull FileVisitDetails fileDetails) {
            fileDetails.getFile();
        }
    }
}

