/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.neoform.runtime.tasks.AbstractInjectSource;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.Nullable;

public abstract class InjectFromFileTreeSource
extends AbstractInjectSource {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getFiles();

    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        FileTree matching = this.getFiles().getAsFileTree().matching((PatternFilterable)this.createFilter()).matching(pattern -> pattern.include(new String[]{path}));
        if (matching.isEmpty()) {
            return null;
        }
        return Files.readAllBytes(matching.getSingleFile().toPath());
    }

    @Override
    public void copyTo(ZipOutputStream out) throws IOException {
        if (this.getFiles().isEmpty()) {
            return;
        }
        FileTree source = this.getFiles().getAsFileTree().matching((PatternFilterable)this.createFilter());
        source.visit((FileVisitor)new ZipBuildingFileTreeVisitor(out));
    }
}

