/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LogLevel;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.File;
import java.io.OutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class Patch
extends DefaultRuntime {
    public Patch() {
        this.getRejectsFile().fileProvider(this.getFileInOutputDirectory("rejects.zip"));
        this.getIsVerbose().convention((Object)false);
    }

    @TaskAction
    public void run() throws Exception {
        boolean success;
        File input = ((RegularFile)this.getInput().get()).getAsFile();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        File rejects = ((RegularFile)this.getRejectsFile().get()).getAsFile();
        File patchArchive = ((RegularFile)this.getPatchArchive().get()).getAsFile();
        PatchOperation.Builder builder = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), org.gradle.api.logging.LogLevel.LIFECYCLE)).basePath(input.toPath()).patchesPath(patchArchive.toPath(), ArchiveFormat.ZIP).patchesPrefix((String)this.getPatchDirectory().get()).outputPath(output.toPath()).level((Boolean)this.getIsVerbose().get() != false ? LogLevel.ALL : LogLevel.WARN).mode(PatchMode.OFFSET).rejectsPath(rejects.toPath());
        if (this.getPatchesModifiedPrefix().isPresent()) {
            builder = builder.bPrefix((String)this.getPatchesModifiedPrefix().get());
        }
        if (this.getPatchesOriginalPrefix().isPresent()) {
            builder = builder.aPrefix((String)this.getPatchesOriginalPrefix().get());
        }
        CliOperation.Result result = builder.build().operate();
        boolean bl = success = result.exit == 0;
        if (!success) {
            this.getProject().getLogger().error("Rejects saved to: {}", (Object)rejects);
            throw new RuntimeException("Patch failure.");
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getPatchArchive();

    @Input
    public abstract Property<String> getPatchDirectory();

    @OutputFile
    public abstract RegularFileProperty getRejectsFile();

    @Input
    public abstract Property<Boolean> getIsVerbose();

    @Input
    @Optional
    public abstract Property<String> getPatchesOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getPatchesModifiedPrefix();
}

