/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.neoform.runtime.tasks.AbstractInjectSource;
import net.neoforged.gradle.neoform.runtime.tasks.ZipEntryFileTreeElement;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.Nullable;

public abstract class InjectFromZipSource
extends AbstractInjectSource {
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getZipFile();

    /*
     * Loose catch block
     */
    @Override
    public byte @Nullable [] tryReadFile(String path) throws IOException {
        block28: {
            Throwable throwable = null;
            try (ZipFile zf = new ZipFile((File)this.getZipFile().getAsFile().get());){
                ZipEntry entry = zf.getEntry(path);
                if (entry != null) {
                    try (InputStream in = zf.getInputStream(entry);){
                        byte[] byArray = IOUtils.toByteArray((InputStream)in);
                        return byArray;
                    }
                }
                break block28;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void copyTo(ZipOutputStream out) throws IOException {
        Spec spec = this.createFilter().getAsSpec();
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream((File)this.getZipFile().getAsFile().get()));){
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                block17: {
                    if (spec.isSatisfiedBy((Object)new ZipEntryFileTreeElement(entry))) {
                        try {
                            out.putNextEntry(entry);
                            IOUtils.copyLarge((InputStream)zin, (OutputStream)out);
                            out.closeEntry();
                        }
                        catch (ZipException e) {
                            if (!e.getMessage().startsWith("duplicate entry:")) {
                                throw e;
                            }
                            if (entry.isDirectory()) break block17;
                            this.getLogger().warn("Cannot inject duplicate file {}", (Object)entry.getName());
                        }
                    }
                }
                entry = zin.getNextEntry();
            }
        }
    }
}

