/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.neoform.runtime.specification;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV2;
import net.neoforged.gradle.dsl.neoform.runtime.specification.NeoFormSpecification;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.util.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

public class NeoFormRuntimeSpecification
extends CommonRuntimeSpecification
implements NeoFormSpecification {
    private final File neoFormArchive;
    private final NeoFormConfigConfigurationSpecV2 config;
    private final FileCollection additionalRecompileDependencies;

    private NeoFormRuntimeSpecification(Project project, String version, File neoFormArchive, NeoFormConfigConfigurationSpecV2 config, DistributionType side, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, FileCollection additionalRecompileDependencies) {
        super(project, "neoForm", version, side, preTaskTypeAdapters, postTypeAdapters, taskCustomizers, NeoFormRuntimeExtension.class);
        this.neoFormArchive = neoFormArchive;
        this.config = config;
        this.additionalRecompileDependencies = additionalRecompileDependencies;
    }

    public NeoFormConfigConfigurationSpecV2 getConfig() {
        return this.config;
    }

    public String getMinecraftVersion() {
        return this.config.getVersion();
    }

    public String getNeoFormVersion() {
        String prefix = this.getMinecraftVersion() + "-";
        if (this.getVersion().startsWith(prefix)) {
            return this.getVersion().substring(prefix.length());
        }
        throw new RuntimeException("NeoForm version " + this.getVersion() + " does not start with Minecraft version" + this.getMinecraftVersion());
    }

    public File getNeoFormArchive() {
        return this.neoFormArchive;
    }

    public FileCollection getAdditionalRecompileDependencies() {
        return this.additionalRecompileDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NeoFormRuntimeSpecification)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NeoFormRuntimeSpecification spec = (NeoFormRuntimeSpecification)((Object)o);
        if (!this.neoFormArchive.equals(spec.neoFormArchive)) {
            return false;
        }
        return this.additionalRecompileDependencies.equals(spec.additionalRecompileDependencies);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.neoFormArchive.hashCode();
        result = 31 * result + this.additionalRecompileDependencies.hashCode();
        return result;
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<NeoFormRuntimeSpecification, Builder>
    implements NeoFormSpecification.Builder<NeoFormRuntimeSpecification, Builder> {
        private Dependency neoFormDependency;
        private FileCollection additionalDependencies;

        private Builder(Project project) {
            super(project);
            this.additionalDependencies = project.getObjects().fileCollection();
            this.withNeoFormVersion("+");
        }

        protected Builder getThis() {
            return this;
        }

        public static Builder from(Project project) {
            return new Builder(project);
        }

        @NotNull
        public Builder withNeoFormVersion(@NotNull String version) {
            this.neoFormDependency = this.project.getDependencies().create((Object)("net.neoforged:neoform:" + version + "@zip"));
            return this.getThis();
        }

        @NotNull
        public Builder withNeoFormDependency(@NotNull Object notation) {
            this.neoFormDependency = this.getProject().getDependencies().create(notation);
            return this.getThis();
        }

        public Builder withAdditionalDependencies(FileCollection files) {
            this.additionalDependencies = this.additionalDependencies.plus(files);
            return this.getThis();
        }

        public NeoFormRuntimeSpecification build() {
            NeoFormConfigConfigurationSpecV2 config;
            ResolvedArtifact artifact = ToolUtilities.resolveToolArtifact((Project)this.project, (Dependency)this.neoFormDependency);
            File archive = artifact.getFile();
            String effectiveVersion = artifact.getModuleVersion().getId().getVersion();
            try {
                config = (NeoFormConfigConfigurationSpecV2)FileUtils.processFileFromZip((File)archive, (String)"config.json", NeoFormConfigConfigurationSpecV2::get);
            }
            catch (IOException e) {
                throw new GradleException("Failed to read NeoForm config file from version " + effectiveVersion);
            }
            return new NeoFormRuntimeSpecification(this.project, effectiveVersion, archive, config, (DistributionType)this.distributionType.get(), this.preTaskAdapters, this.postTaskAdapters, this.taskCustomizers, this.additionalDependencies);
        }
    }
}

