/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.mixin;

import java.util.Set;
import net.neoforged.gradle.common.CommonProjectPlugin;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.mixin.extension.Mixin;
import net.neoforged.gradle.mixin.MixinExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.bundling.Jar;

public class MixinProjectPlugin
implements Plugin<Project> {
    private Mixin extension;

    public void apply(Project project) {
        if (project.getPlugins().findPlugin(CommonProjectPlugin.class) == null) {
            throw new IllegalStateException("The mixin extension requires the common plugin to be applied first.");
        }
        this.extension = (Mixin)project.getExtensions().create(Mixin.class, "mixin", MixinExtension.class, new Object[]{project});
        project.afterEvaluate(p -> {
            p.getTasks().withType(Jar.class).all(this::configureJarTask);
            p.getExtensions().configure("runs", runs -> runs.all(this::configureRun));
        });
    }

    private void configureJarTask(Jar jar) {
        jar.getManifest().getAttributes().computeIfAbsent((Object)"MixinConfigs", $ -> String.join((CharSequence)",", (Iterable)this.extension.getConfigs().get()));
    }

    private void configureRun(Run run) {
        ListProperty programArguments = run.getProgramArguments();
        for (String config : (Set)this.extension.getConfigs().get()) {
            programArguments.addAll((Object[])new String[]{"--mixin.config", config});
        }
    }
}

