/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.mixin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.neoforged.gradle.common.CommonProjectPlugin;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.mixin.extension.Mixin;
import net.neoforged.gradle.mixin.MixinExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.bundling.Jar;

public class MixinProjectPlugin
implements Plugin<Project> {
    private Mixin extension;

    public void apply(Project project) {
        if (project.getPlugins().findPlugin(CommonProjectPlugin.class) == null) {
            throw new IllegalStateException("The mixin extension requires the common plugin to be applied first.");
        }
        this.extension = (Mixin)project.getExtensions().create(Mixin.class, "mixin", MixinExtension.class, new Object[]{project});
        project.getTasks().withType(Jar.class).configureEach(this::setupJarTask);
        project.getExtensions().configure(RunManager.class, runs -> runs.configureAll(this::setupRun));
        project.afterEvaluate(p -> {
            p.getTasks().withType(Jar.class).all(this::configureJarTask);
            p.getExtensions().configure(RunManager.class, runs -> runs.configureAll(this::configureRun));
        });
    }

    private void setupJarTask(Jar jarTask) {
        jarTask.getExtensions().create("mixin", MixinExtension.class, new Object[]{jarTask.getProject()});
    }

    private void configureJarTask(Jar jar) {
        jar.getManifest().getAttributes().computeIfAbsent((Object)"MixinConfigs", $ -> {
            HashSet configs = new HashSet((Collection)this.extension.getConfigs().get());
            configs.addAll((Collection)((MixinExtension)jar.getExtensions().getByType(MixinExtension.class)).getConfigs().get());
            return String.join((CharSequence)",", configs);
        });
    }

    private void setupRun(Run run) {
        run.getExtensions().create("mixin", MixinExtension.class, new Object[]{run.getProject()});
    }

    private void configureRun(Run run) {
        ListProperty programArguments = run.getArguments();
        for (String config : (Set)this.extension.getConfigs().get()) {
            programArguments.addAll((Object[])new String[]{"--fml.mixin", config});
        }
        MixinExtension runExtension = (MixinExtension)run.getExtensions().getByType(MixinExtension.class);
        for (String config : (Set)runExtension.getConfigs().get()) {
            programArguments.addAll((Object[])new String[]{"--fml.mixin", config});
        }
    }
}

