/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.platform.util;

import java.net.URI;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.ProviderFactory;

public class RepositoryCollection {
    private final ListProperty<URI> urls;

    public RepositoryCollection(ProviderFactory providers, ObjectFactory objects, RepositoryHandler handler) {
        this.urls = objects.listProperty(URI.class);
        handler.withType(MavenArtifactRepository.class).configureEach(repo -> this.urls.add(providers.provider(() -> ((MavenArtifactRepository)repo).getUrl()).map(RepositoryCollection::addTrailingSlash)));
    }

    public ListProperty<URI> getURLs() {
        return this.urls;
    }

    private static URI addTrailingSlash(URI uri) {
        String asString = uri.toString();
        if (asString.endsWith("/")) {
            return uri;
        }
        return URI.create(asString + "/");
    }
}

