/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.platform.util;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import net.neoforged.gradle.dsl.platform.model.Artifact;
import net.neoforged.gradle.dsl.platform.model.Library;
import net.neoforged.gradle.dsl.platform.model.LibraryDownload;
import net.neoforged.gradle.dsl.platform.util.ModuleIdentificationVisitor;
import net.neoforged.gradle.util.HashFunction;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.Nullable;

public class LibraryCollector
extends ModuleIdentificationVisitor {
    private static final String HOST_WHITELIST;
    private static final URI MOJANG_MAVEN;
    private static final URI NEOFORGED_MAVEN;
    private final ObjectFactory objectFactory;
    private final List<URI> repositoryUrls;
    private final List<Future<Library>> libraries;
    private final HttpClient httpClient;
    private final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public LibraryCollector(ObjectFactory objectFactory, List<URI> repoUrl, Logger logger) {
        super(objectFactory);
        ObjectFactory objectFactory2;
        Logger logger2;
        MetaClass metaClass;
        HttpClient httpClient;
        ArrayList<Future<Library>> arrayList = new ArrayList<Future<Library>>();
        this.libraries = arrayList;
        this.httpClient = httpClient = HttpClient.newBuilder().build();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.logger = logger2 = logger;
        this.objectFactory = objectFactory2 = objectFactory;
        ArrayList<URI> arrayList2 = new ArrayList<URI>(repoUrl);
        this.repositoryUrls = arrayList2;
        this.repositoryUrls.removeIf((Predicate<URI>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _closure1(this, this))));
        this.repositoryUrls.removeIf((Predicate<URI>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _closure2(this, this))));
        this.repositoryUrls.removeIf((Predicate<URI>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _closure3(this, this))));
        this.repositoryUrls.removeIf((Predicate<URI>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _closure4(this, this))));
        this.repositoryUrls.add(0, NEOFORGED_MAVEN);
        this.repositoryUrls.add(0, MOJANG_MAVEN);
        logger.info("Collecting libraries from:");
        List<URI> list = this.repositoryUrls;
        URI repo = null;
        Iterator<URI> iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                repo = iterator.next();
                logger.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{repo}, new String[]{" - ", ""}))));
            }
        }
    }

    public void visit(ResolvedArtifactResult artifactResult) {
        ComponentIdentifier componentId = artifactResult.getId().getComponentIdentifier();
        if (componentId instanceof ModuleComponentIdentifier) {
            this.visitModule(artifactResult.getFile(), IndyInterface.bootstrap("cast", "()", 0, componentId).getGroup(), IndyInterface.bootstrap("cast", "()", 0, componentId).getModule(), IndyInterface.bootstrap("cast", "()", 0, componentId).getVersion(), LibraryCollector.guessMavenClassifier(artifactResult.getFile(), (ModuleComponentIdentifier)IndyInterface.bootstrap("cast", "()", 0, componentId)), FilenameUtils.getExtension((String)artifactResult.getFile().getName()));
        } else {
            this.logger.warn(StringGroovyMethods.plus((CharSequence)"Cannot handle component: ", (Object)componentId));
        }
    }

    public static String guessMavenClassifier(File file, ModuleComponentIdentifier id) {
        String artifact = id.getModule();
        String version = id.getVersion();
        String expectedBasename = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)artifact, (CharSequence)"-"), (CharSequence)version);
        String filename = file.getName();
        int startOfExt = filename.lastIndexOf(".");
        if (startOfExt != -1) {
            filename = filename.substring(0, startOfExt);
        }
        if (filename.startsWith(StringGroovyMethods.plus((String)expectedBasename, (CharSequence)"-"))) {
            return filename.substring(StringGroovyMethods.plus((String)expectedBasename, (CharSequence)"-").length());
        }
        return "";
    }

    @Override
    protected void visitModule(File file, String group, String module, String version, @Nullable String classifier, String extension) throws Exception {
        Reference library = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, this.objectFactory.newInstance(Library.class, new Object[0])));
        CallSite download = IndyInterface.bootstrap("cast", "()", 0, this.objectFactory.newInstance(LibraryDownload.class, new Object[0]));
        Reference artifact = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, this.objectFactory.newInstance(Artifact.class, new Object[0])));
        ((Library)library.get()).getDownload().set((Object)download);
        ((LibraryDownload)((Object)download)).getArtifact().set((Object)((Artifact)artifact.get()));
        Reference name = new Reference((Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)group, (CharSequence)":"), (CharSequence)module), (CharSequence)":"), (CharSequence)version), (CharSequence)(classifier.isEmpty() ? "" : StringGroovyMethods.plus((String)":", (CharSequence)classifier))), (CharSequence)"@"), (CharSequence)extension));
        String path = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)group.replace(".", "/"), (CharSequence)"/"), (CharSequence)module), (CharSequence)"/"), (CharSequence)version), (CharSequence)"/"), (CharSequence)module), (CharSequence)"-"), (CharSequence)version), (CharSequence)(classifier.isEmpty() ? "" : StringGroovyMethods.plus((String)"-", (CharSequence)classifier))), (CharSequence)"."), (CharSequence)extension);
        ((Library)library.get()).getName().set((Object)((String)name.get()));
        try {
            ((Artifact)artifact.get()).getPath().set((Object)path);
            ((Artifact)artifact.get()).getSha1().set((Object)HashFunction.SHA1.hash(file));
            ((Artifact)artifact.get()).getSize().set((Object)Files.size(file.toPath()));
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
        Object libraryFuture = null;
        List<URI> list = this.repositoryUrls;
        URI repositoryUrl = null;
        Iterator<URI> iterator = list != null ? list.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                repositoryUrl = iterator.next();
                Reference artifactUri = new Reference((Object)LibraryCollector.joinUris((URI)((Object)IndyInterface.bootstrap("cast", "()", 0, repositoryUrl)), path));
                Reference request = new Reference((Object)HttpRequest.newBuilder((URI)artifactUri.get()).method("HEAD", HttpRequest.BodyPublishers.noBody()).build());
                LibraryCollector libraryCollector = this;
                public final class _visitModule_lambda5
                extends Closure
                implements GeneratedLambda {
                    private /* synthetic */ Reference request;
                    private /* synthetic */ Reference artifactUri;
                    private /* synthetic */ Reference name;
                    private /* synthetic */ Reference artifact;
                    private /* synthetic */ Reference library;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _visitModule_lambda5(Object _outerInstance, Object _thisObject, Reference request, Reference artifactUri, Reference name, Reference artifact, Reference library) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        Reference reference5;
                        this.request = reference5 = request;
                        this.artifactUri = reference4 = artifactUri;
                        this.name = reference3 = name;
                        this.artifact = reference2 = artifact;
                        this.library = reference = library;
                    }

                    public R doCall(String previousError) {
                        Reference previousError2 = new Reference((Object)previousError);
                        public final class _closure9
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference artifactUri;
                            private /* synthetic */ Reference previousError;
                            private /* synthetic */ Reference name;
                            private /* synthetic */ Reference artifact;
                            private /* synthetic */ Reference library;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure9(Object _outerInstance, Object _thisObject, Reference artifactUri, Reference previousError, Reference name, Reference artifact, Reference library) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                Reference reference5;
                                this.artifactUri = reference5 = artifactUri;
                                this.previousError = reference4 = previousError;
                                this.name = reference3 = name;
                                this.artifact = reference2 = artifact;
                                this.library = reference = library;
                            }

                            public Library doCall(HttpResponse<Void> response) {
                                if (response.statusCode() != 200) {
                                    ((LibraryCollector)this.getThisObject()).logger.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{response.statusCode(), IndyInterface.bootstrap("cast", "()", 0, this.artifactUri.get())}, new String[]{"  Got ", " for ", ""}))));
                                    Object message = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.artifactUri.get()), response.statusCode()}, new String[]{"Could not find ", ": ", ""}));
                                    if (IndyInterface.bootstrap("cast", "()", 0, this.previousError.get()) != null) {
                                        message = StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.previousError.get())), (CharSequence)"\n"), (CharSequence)message);
                                    }
                                    throw (Throwable)new RuntimeException((String)message);
                                }
                                ((LibraryCollector)this.getThisObject()).logger.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.name.get()), IndyInterface.bootstrap("cast", "()", 0, this.artifactUri.get())}, new String[]{"  Found ", " -> ", ""}))));
                                ((Artifact)((Object)IndyInterface.bootstrap("cast", "()", 0, this.artifact.get()))).getUrl().set((Object)((URI)((Object)IndyInterface.bootstrap("cast", "()", 0, this.artifactUri.get()))).toString());
                                return IndyInterface.bootstrap("cast", "()", 0, this.library.get());
                            }

                            @Generated
                            public Library call(HttpResponse<Void> response) {
                                return this.doCall(response);
                            }

                            @Generated
                            public URI getArtifactUri() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.artifactUri.get());
                            }

                            @Generated
                            public String getPreviousError() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.previousError.get());
                            }

                            @Generated
                            public String getName() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
                            }

                            @Generated
                            public Artifact getArtifact() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.artifact.get());
                            }

                            @Generated
                            public Library getLibrary() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.library.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure9.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        return ((LibraryCollector)this.getThisObject()).httpClient.sendAsync((HttpRequest)((Object)IndyInterface.bootstrap("cast", "()", 0, this.request.get())), HttpResponse.BodyHandlers.discarding()).thenApply((Function)((Object)IndyInterface.bootstrap("cast", "()", 0, new _closure9((Object)this, this.getThisObject(), this.artifactUri, previousError2, this.name, this.artifact, this.library))));
                    }

                    @Generated
                    public HttpRequest getRequest() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.request.get());
                    }

                    @Generated
                    public URI getArtifactUri() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.artifactUri.get());
                    }

                    @Generated
                    public String getName() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
                    }

                    @Generated
                    public Artifact getArtifact() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.artifact.get());
                    }

                    @Generated
                    public Library getLibrary() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.library.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _visitModule_lambda5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Reference makeRequest = new Reference(new _visitModule_lambda5(libraryCollector, libraryCollector, request, artifactUri, name, artifact, library)::doCall);
                if (libraryFuture == null) {
                    libraryFuture = IndyInterface.bootstrap("cast", "()", 0, ((Function)makeRequest.get()).apply(null));
                    continue;
                }
                public final class _visitModule_closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference makeRequest;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _visitModule_closure6(Object _outerInstance, Object _thisObject, Reference makeRequest) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.makeRequest = reference = makeRequest;
                    }

                    public CompletableFuture<Library> doCall(Throwable error) {
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.makeRequest.get()).apply(error.getMessage()));
                    }

                    @Generated
                    public CompletableFuture<Library> call(Throwable error) {
                        return this.doCall(error);
                    }

                    @Generated
                    public Function getMakeRequest() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.makeRequest.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _visitModule_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                ((CompletableFuture)libraryFuture).exceptionallyCompose((Function)((Object)IndyInterface.bootstrap("cast", "()", 0, new _visitModule_closure6(this, this, makeRequest))));
            }
        }
        this.libraries.add((Future<Library>)libraryFuture);
    }

    private static URI joinUris(URI repositoryUrl, String path) {
        String baseUrl = repositoryUrl.toString();
        if (baseUrl.endsWith("/") && path.startsWith("/")) {
            while (path.startsWith("/")) {
                path.substring(1);
            }
            return URI.create(StringGroovyMethods.plus((String)baseUrl, (CharSequence)path));
        }
        if (!baseUrl.endsWith("/") && !path.startsWith("/")) {
            return URI.create(StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)baseUrl, (CharSequence)"/"), (CharSequence)path));
        }
        return URI.create(StringGroovyMethods.plus((String)baseUrl, (CharSequence)path));
    }

    public Set<Library> getLibraries() {
        public final class _getLibraries_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLibraries_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Library doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, ((Future)it).get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Library doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLibraries_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        List result = DefaultGroovyMethods.collect(this.libraries, (Closure)new _getLibraries_closure7(this, this));
        this.logger.info((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{result.size()}, new String[]{"Collected ", " libraries"}))));
        return new HashSet<Library>(result);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LibraryCollector.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ String pfaccess$0(LibraryCollector $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(LibraryCollector.class, LibraryCollector.class, (String)"HOST_WHITELIST"));
    }

    public static /* synthetic */ URI pfaccess$1(LibraryCollector $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(LibraryCollector.class, LibraryCollector.class, (String)"MOJANG_MAVEN"));
    }

    public static /* synthetic */ URI pfaccess$2(LibraryCollector $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(LibraryCollector.class, LibraryCollector.class, (String)"NEOFORGED_MAVEN"));
    }

    static {
        URI uRI;
        URI uRI2;
        List<String> list = List.of("minecraft.net", "neoforged.net", "mojang.com");
        HOST_WHITELIST = IndyInterface.bootstrap("cast", "()", 0, list);
        MOJANG_MAVEN = uRI2 = URI.create("https://libraries.minecraft.net");
        NEOFORGED_MAVEN = uRI = URI.create("https://maven.neoforged.net/releases");
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Boolean doCall(Object it) {
            String lowercaseScheme = ((URI)it).getScheme().toLowerCase(Locale.ROOT);
            return ScriptBytecodeAdapter.compareNotEqual((Object)lowercaseScheme, (Object)"https") && ScriptBytecodeAdapter.compareNotEqual((Object)lowercaseScheme, (Object)"http");
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Boolean doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Boolean doCall(URI uri) {
            Reference lowercaseHost = new Reference((Object)uri.getHost().toLowerCase(Locale.ROOT));
            public final class _closure8
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference lowercaseHost;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _closure8(Object _outerInstance, Object _thisObject, Reference lowercaseHost) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.lowercaseHost = reference = lowercaseHost;
                }

                public Boolean doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.lowercaseHost.get()), (Object)it) || ((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.lowercaseHost.get()))).endsWith(StringGroovyMethods.plus((CharSequence)".", (Object)it));
                }

                @Generated
                public String getLowercaseHost() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.lowercaseHost.get());
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Boolean doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _closure8.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            return !DefaultGroovyMethods.any((Object)LibraryCollector.pfaccess$0(null), (Closure)new _closure8((Object)this, this.getThisObject(), lowercaseHost));
        }

        @Generated
        public Boolean call(URI uri) {
            return this.doCall(uri);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure3
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure3(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Boolean doCall(Object it) {
            return ScriptBytecodeAdapter.compareEqual((Object)((URI)it).getHost(), (Object)LibraryCollector.pfaccess$1(null).getHost());
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Boolean doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure3.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure4
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure4(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Boolean doCall(Object it) {
            return ScriptBytecodeAdapter.compareEqual((Object)((URI)it).getHost(), (Object)LibraryCollector.pfaccess$2(null).getHost()) && ((URI)it).getPath().startsWith(LibraryCollector.pfaccess$2(null).getPath());
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public Boolean doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure4.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

