/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.platform.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.gradle.dsl.platform.model.Artifact;
import net.neoforged.gradle.dsl.platform.model.Library;
import net.neoforged.gradle.dsl.platform.model.LibraryDownload;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleIdentificationVisitor
implements FileVisitor,
GroovyObject {
    private static final Pattern GRADLE_CACHE_PATTERN;
    private static final Pattern MAVEN_LOCAL_PATTERN;
    private final ObjectFactory objectFactory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ModuleIdentificationVisitor(ObjectFactory objectFactory) {
        ObjectFactory objectFactory2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.objectFactory = objectFactory2 = objectFactory;
    }

    public void visitDir(FileVisitDetails dirDetails) {
    }

    public void visitFile(FileVisitDetails fileDetails) {
        File file = fileDetails.getFile();
        String absolutePath = file.getAbsolutePath().replace("\\", "/");
        Matcher matcher = GRADLE_CACHE_PATTERN.matcher(absolutePath);
        if (!matcher.find()) {
            matcher = MAVEN_LOCAL_PATTERN.matcher(absolutePath);
            if (!matcher.find()) {
                throw (Throwable)new IllegalStateException(StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"Cannot determine the GAV of ", (Object)file), (CharSequence)", since it is neither a remote nor a Maven local dependency!"));
            }
        }
        CallSite library = IndyInterface.bootstrap("cast", "()", 0, this.objectFactory.newInstance(Library.class, new Object[0]));
        CallSite download = IndyInterface.bootstrap("cast", "()", 0, this.objectFactory.newInstance(LibraryDownload.class, new Object[0]));
        CallSite artifact = IndyInterface.bootstrap("cast", "()", 0, this.objectFactory.newInstance(Artifact.class, new Object[0]));
        ((Library)((Object)library)).getDownload().set((Object)download);
        ((LibraryDownload)((Object)download)).getArtifact().set((Object)artifact);
        String group = matcher.group("group").replace("/", ".");
        String module = matcher.group("module");
        String version = matcher.group("version");
        String classifier = matcher.group("classifier") == null ? "" : matcher.group("classifier");
        String extension = matcher.group("extension");
        try {
            this.visitModule(file, group, module, version, classifier, extension);
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    protected abstract void visitModule(File var1, String var2, String var3, String var4, @Nullable String var5, String var6) throws Exception;

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ModuleIdentificationVisitor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Pattern pattern;
        Pattern pattern2;
        GRADLE_CACHE_PATTERN = pattern2 = Pattern.compile("/(?<group>[^/]+)/(?<module>[^/]+)/(?<version>[^/]+)/(?<hash>[a-z0-9]+)/\\k<module>-\\k<version>(-(?<classifier>[^/]+))?\\.(?<extension>(jar)|(zip))$");
        MAVEN_LOCAL_PATTERN = pattern = Pattern.compile("/.m2/repository/(?<group>.+)/(?<module>[^/]+)/(?<version>[^/]+)/\\k<module>-\\k<version>(-(?<classifier>[^/]+))?\\.(?<extension>(jar)|(zip))$");
    }
}

