/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.neoform.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.neoforged.gradle.dsl.common.configuration.VersionedConfiguration;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class NeoFormConfigConfigurationSpecV1
extends VersionedConfiguration {
    protected static final Gson GSON = new GsonBuilder().registerTypeAdapter(Step.class, (Object)new Step.Deserializer()).setPrettyPrinting().create();
    protected String version;
    @Nullable
    protected Map<String, Object> data;
    @Nullable
    protected Map<String, List<Step>> steps;
    @Nullable
    protected Map<String, Function> functions;
    @Nullable
    protected Map<String, List<String>> libraries;

    public static NeoFormConfigConfigurationSpecV1 get(InputStream stream) {
        return (NeoFormConfigConfigurationSpecV1)((Object)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), NeoFormConfigConfigurationSpecV1.class));
    }

    public static NeoFormConfigConfigurationSpecV1 get(byte[] data) {
        return NeoFormConfigConfigurationSpecV1.get(new ByteArrayInputStream(data));
    }

    @Input
    public String getVersion() {
        return this.version;
    }

    @Nested
    @Optional
    public Map<String, Object> getData() {
        return this.data == null ? Collections.emptyMap() : this.data;
    }

    @Nullable
    public String getData(String ... path) {
        if (this.data == null) {
            return null;
        }
        Map level = this.data;
        for (String part : path) {
            if (!level.containsKey(part)) {
                return null;
            }
            Object val = level.get(part);
            if (val instanceof String) {
                return (String)val;
            }
            if (!(val instanceof Map)) continue;
            level = (Map)val;
        }
        return null;
    }

    @Optional
    @Nested
    @Nullable
    public Map<String, List<Step>> getSteps() {
        return this.steps;
    }

    public List<Step> getSteps(String side) {
        List<Step> ret = this.steps == null ? null : this.steps.get(side);
        return ret == null ? Collections.emptyList() : ret;
    }

    @Nested
    @Optional
    public Map<String, Function> getFunctions() {
        return this.functions == null ? Collections.emptyMap() : this.functions;
    }

    public List<String> getLibraries(String side) {
        List<String> ret = this.libraries == null ? null : this.libraries.get(side);
        return ret == null ? Collections.emptyList() : ret;
    }

    @Nested
    @Optional
    @Nullable
    public Map<String, List<String>> getLibraries() {
        return this.libraries;
    }

    public static class Step {
        private final String type;
        private final String name;
        @Nullable
        private final Map<String, String> values;

        public Step(String type, String name, @Nullable Map<String, String> values) {
            this.type = type;
            this.name = name;
            this.values = values;
        }

        @Input
        public String getType() {
            return this.type;
        }

        @Input
        public String getName() {
            return this.name;
        }

        @Nested
        public Map<String, String> getValues() {
            return this.values == null ? Collections.emptyMap() : this.values;
        }

        @Nullable
        public String getValue(String key) {
            return this.values == null ? null : this.values.get(key);
        }

        public static class Deserializer
        implements JsonDeserializer<Step> {
            public Step deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject obj = json.getAsJsonObject();
                if (!obj.has("type")) {
                    throw new JsonParseException("Could not parse step: Missing 'type'");
                }
                String type = obj.get("type").getAsString();
                String name = obj.has("name") ? obj.get("name").getAsString() : type;
                Map<String, String> values = obj.entrySet().stream().filter(e -> !"type".equals(e.getKey()) && !"name".equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
                return new Step(type, name, values);
            }
        }
    }

    public static class Function {
        protected String version;
        @Nullable
        protected String repo;
        @Nullable
        protected List<String> args;
        @Nullable
        protected List<String> jvmargs;

        public Function() {
        }

        public Function(String version, @Nullable List<String> args, @Nullable List<String> jvmargs) {
            this.version = version;
            this.args = args;
            this.jvmargs = jvmargs;
            this.repo = null;
        }

        public Function(String version, @Nullable List<String> args) {
            this.version = version;
            this.args = args;
            this.jvmargs = List.of();
            this.repo = null;
        }

        @Input
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String value) {
            this.version = value;
        }

        @Input
        @Optional
        public String getRepo() {
            return this.repo == null ? "https://libraries.minecraft.net/" : this.repo;
        }

        public void setRepo(String value) {
            this.repo = value;
        }

        @Input
        @Optional
        public List<String> getArgs() {
            return this.args == null ? Collections.emptyList() : this.args;
        }

        public void setArgs(List<String> value) {
            this.args = value;
        }

        @Input
        @Optional
        public List<String> getJvmArgs() {
            return this.jvmargs == null ? Collections.emptyList() : this.jvmargs;
        }

        public void setJvmArgs(List<String> value) {
            this.jvmargs = value;
        }
    }
}

