/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.neoform.configuration;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV1;
import org.apache.commons.io.IOUtils;
import org.gradle.api.tasks.Input;

public class NeoFormConfigConfigurationSpecV2
extends NeoFormConfigConfigurationSpecV1 {
    private boolean official = false;
    private int java_target = 8;
    @Nullable
    private String encoding = "UTF-8";

    public static NeoFormConfigConfigurationSpecV2 get(File file) {
        NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2;
        FileInputStream stream = new FileInputStream(file);
        try {
            neoFormConfigConfigurationSpecV2 = NeoFormConfigConfigurationSpecV2.get(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)stream).close();
        return neoFormConfigConfigurationSpecV2;
    }

    public static NeoFormConfigConfigurationSpecV2 get(InputStream stream) {
        NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2;
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            neoFormConfigConfigurationSpecV2 = (NeoFormConfigConfigurationSpecV2)((Object)GSON.fromJson((Reader)reader, NeoFormConfigConfigurationSpecV2.class));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return neoFormConfigConfigurationSpecV2;
    }

    public static NeoFormConfigConfigurationSpecV2 get(byte[] data) {
        return NeoFormConfigConfigurationSpecV2.get(new ByteArrayInputStream(data));
    }

    public static NeoFormConfigConfigurationSpecV2 getFromArchive(File path) throws IOException {
        try (ZipFile zip = new ZipFile(path);){
            ZipEntry entry = zip.getEntry("config.json");
            if (entry == null) {
                throw new IllegalStateException("Could not find 'config.json' in " + path.getAbsolutePath());
            }
            byte[] data = IOUtils.toByteArray((InputStream)zip.getInputStream(entry));
            int spec = NeoFormConfigConfigurationSpecV2.getSpec((byte[])data);
            if (spec == 2 || spec == 3) {
                NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2 = NeoFormConfigConfigurationSpecV2.get(data);
                return neoFormConfigConfigurationSpecV2;
            }
            if (spec == 1) {
                NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2 = new NeoFormConfigConfigurationSpecV2(NeoFormConfigConfigurationSpecV1.get(data));
                return neoFormConfigConfigurationSpecV2;
            }
            throw new IllegalStateException("Invalid NeoForm Config: " + path.getAbsolutePath() + " Unknown spec: " + spec);
        }
    }

    @Input
    public boolean isOfficial() {
        return this.official;
    }

    @Input
    public int getJavaTarget() {
        return this.java_target;
    }

    @Input
    public String getEncoding() {
        return this.encoding == null ? "UTF-8" : this.encoding;
    }

    public NeoFormConfigConfigurationSpecV2(NeoFormConfigConfigurationSpecV1 old) {
        this.version = old.version;
        this.data = old.data;
        this.steps = old.steps;
        this.functions = old.functions;
        this.libraries = old.libraries;
    }
}

