/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.neoform.configuration;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV1;
import org.apache.commons.io.IOUtils;
import org.gradle.api.tasks.Input;

public class NeoFormConfigConfigurationSpecV2
extends NeoFormConfigConfigurationSpecV1 {
    private boolean official = false;
    private int java_target = 8;
    @Nullable
    private String encoding = "UTF-8";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NeoFormConfigConfigurationSpecV2 get(File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2 = NeoFormConfigConfigurationSpecV2.get(stream);
            return neoFormConfigConfigurationSpecV2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NeoFormConfigConfigurationSpecV2 get(InputStream stream) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2 = (NeoFormConfigConfigurationSpecV2)((Object)GSON.fromJson((Reader)reader, NeoFormConfigConfigurationSpecV2.class));
            return neoFormConfigConfigurationSpecV2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static NeoFormConfigConfigurationSpecV2 get(byte[] data) {
        return NeoFormConfigConfigurationSpecV2.get(new ByteArrayInputStream(data));
    }

    public static NeoFormConfigConfigurationSpecV2 getFromArchive(File path) throws IOException {
        Throwable throwable = null;
        try (ZipFile zip = new ZipFile(path);){
            ZipEntry entry = zip.getEntry("config.json");
            if (entry == null) {
                throw new IllegalStateException("Could not find 'config.json' in " + path.getAbsolutePath());
            }
            byte[] data = IOUtils.toByteArray((InputStream)zip.getInputStream(entry));
            int spec = NeoFormConfigConfigurationSpecV2.getSpec((byte[])data);
            if (spec == 2 || spec == 3) {
                NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2 = NeoFormConfigConfigurationSpecV2.get(data);
                return neoFormConfigConfigurationSpecV2;
            }
            if (spec == 1) {
                NeoFormConfigConfigurationSpecV2 neoFormConfigConfigurationSpecV2 = new NeoFormConfigConfigurationSpecV2(NeoFormConfigConfigurationSpecV1.get(data));
                return neoFormConfigConfigurationSpecV2;
            }
            try {
                throw new IllegalStateException("Invalid NeoForm Config: " + path.getAbsolutePath() + " Unknown spec: " + spec);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Input
    public boolean isOfficial() {
        return this.official;
    }

    @Input
    public int getJavaTarget() {
        return this.java_target;
    }

    @Input
    public String getEncoding() {
        return this.encoding == null ? "UTF-8" : this.encoding;
    }

    public NeoFormConfigConfigurationSpecV2(NeoFormConfigConfigurationSpecV1 old) {
        this.version = old.version;
        this.data = old.data;
        this.steps = old.steps;
        this.functions = old.functions;
        this.libraries = old.libraries;
    }
}

