package net.neoforged.gradle.dsl.common.runtime.tasks

import groovy.transform.CompileStatic
import net.neoforged.gdi.ConfigurableDSLElement
import net.neoforged.gdi.annotations.DSLProperty
import org.gradle.api.file.Directory
import org.gradle.api.file.RegularFile
import org.gradle.api.file.RegularFileProperty
import org.gradle.api.provider.ListProperty
import org.gradle.api.provider.MapProperty
import org.gradle.api.provider.Provider
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.Nested
import org.jetbrains.annotations.Nullable

@CompileStatic
interface RuntimeArguments extends ConfigurableDSLElement<RuntimeArguments> {

    @DSLProperty
    @Input
    abstract MapProperty<String, String> getSimple();

    @DSLProperty
    @Nested
    abstract ListProperty<NamedFileRef> getFiles();

    @Nullable
    Provider<String> get(String key)

    Provider<String> getOrDefault(String key, Provider<String> defaultProvider)

    Provider<Map<String, Provider<String>>> asMap();

    void putFile(String input, Provider<File> fileProvider);

    void putRegularFile(String input, Provider<RegularFile> fileProvider);

    void put(String input, Provider<String> stringProvider);
}