/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.common.runs.run;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.Generated;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.io.File;
import java.util.Set;
import net.neoforged.gdi.BaseDSLElement;
import net.neoforged.gdi.NamedDSLElement;
import net.neoforged.gdi.annotations.DSLProperty;
import net.neoforged.gradle.dsl.common.runs.RunSpecification;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import net.neoforged.gradle.dsl.common.runs.run.RunDevLoginOptions;
import net.neoforged.gradle.dsl.common.runs.run.RunRenderDocOptions;
import net.neoforged.gradle.dsl.common.runs.run.RunSourceSets;
import net.neoforged.gradle.dsl.common.runs.run.RunTestScope;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;

public interface Run
extends BaseDSLElement<Run>,
NamedDSLElement,
RunSpecification {
    @Deprecated
    @Internal
    @DSLProperty(isConfigurable=false)
    public ListProperty<String> getProgramArguments();

    @Internal
    @DSLProperty
    public DirectoryProperty getWorkingDirectory();

    @Nested
    @DSLProperty
    public RunRenderDocOptions getRenderDoc();

    @Nested
    @DSLProperty
    public RunDevLoginOptions getDevLogin();

    @Input
    @Optional
    @DSLProperty(isConfigurable=false)
    public Property<Boolean> getShouldExportToIDE();

    @Nested
    @DSLProperty
    public RunSourceSets getModSources();

    public void modSource(@NotNull SourceSet var1);

    public void modSources(SourceSet ... var1);

    public void modSources(@NotNull Iterable<? extends SourceSet> var1);

    @Nested
    @DSLProperty
    public RunSourceSets getUnitTestSources();

    public void unitTestSource(@NotNull SourceSet var1);

    public void unitTestSources(SourceSet ... var1);

    public void unitTestSources(@NotNull Iterable<? extends SourceSet> var1);

    @Nested
    @DSLProperty
    public RunTestScope getTestScope();

    @InputFiles
    @Classpath
    @DSLProperty
    public ConfigurableFileCollection getRuntimeClasspath();

    @Internal
    public Provider<Set<FileSystemLocation>> getRuntimeClasspathElements();

    @InputFiles
    @Classpath
    @DSLProperty
    public ConfigurableFileCollection getTestRuntimeClasspath();

    @Internal
    public Provider<Set<FileSystemLocation>> getTestRuntimeClasspathElements();

    @InputFiles
    @Classpath
    @DSLProperty
    public ConfigurableFileCollection getCompileClasspath();

    @Internal
    public Provider<Set<FileSystemLocation>> getCompileClasspathElements();

    @InputFiles
    @Classpath
    @DSLProperty
    public ConfigurableFileCollection getTestCompileClasspath();

    @Internal
    public Provider<Set<FileSystemLocation>> getTestCompileClasspathElements();

    @InputFiles
    @Classpath
    @DSLProperty
    public ConfigurableFileCollection getSdkClasspath();

    @Internal
    public Provider<Set<FileSystemLocation>> getSdkClasspathElements();

    @Optional
    @DSLProperty(isConfigurable=false)
    public Property<String> getIDERunName();

    public void runType(@NotNull String var1);

    public void run(@NotNull String var1);

    @Nested
    @DSLProperty
    public DependencyHandler getDependencies();

    @Input
    @Optional
    @DSLProperty(isConfigurable=false)
    public Property<Boolean> getConfigureAutomatically();

    @Input
    @Optional
    @DSLProperty(isConfigurable=false)
    public Property<Boolean> getConfigureFromTypeWithName();

    @Input
    @Optional
    @DSLProperty(isConfigurable=false)
    public Property<Boolean> getConfigureFromDependencies();

    @Internal
    @Optional
    @DSLProperty(isConfigurable=false)
    public SetProperty<Task> getDependsOn();

    @Internal
    @Optional
    @DSLProperty(isConfigurable=false)
    public SetProperty<Task> getPostSyncTasks();

    public void configure();

    @Deprecated
    public void configure(@NotNull String var1);

    public void configure(@NotNull RunSpecification var1);

    public void configure(@NotNull Provider<? extends RunSpecification> var1);

    @Generated
    default public void programArgument(String val) {
        this.getProgramArguments().add((Object)val);
    }

    @Generated
    default public void programArguments(String ... values) {
        this.getProgramArguments().addAll((Object[])values);
    }

    @Generated
    default public void programArguments(Iterable<? extends String> values) {
        this.getProgramArguments().addAll(values);
    }

    @Generated
    default public void workingDirectory(File directory) {
        this.getWorkingDirectory().set(directory);
    }

    @Generated
    default public void workingDirectory(Directory directory) {
        this.getWorkingDirectory().value(directory);
    }

    @Generated
    default public void workingDirectory(Object directory) {
        this.getWorkingDirectory().set(this.getProject().file(directory));
    }

    @Generated
    default public void renderDoc(Action<RunRenderDocOptions> action) {
        action.execute((Object)this.getRenderDoc());
    }

    @Generated
    default public void renderDoc(@DelegatesTo(strategy=1, value=RunRenderDocOptions.class) @ClosureParams(value=SimpleType.class, options={"net.neoforged.gradle.dsl.common.runs.run.RunRenderDocOptions"}) Closure closure) {
        closure.setDelegate((Object)this.getRenderDoc());
        closure.setResolveStrategy(Integer.valueOf(1).intValue());
        closure.call((Object)this.getRenderDoc());
    }

    @Generated
    default public void devLogin(Action<RunDevLoginOptions> action) {
        action.execute((Object)this.getDevLogin());
    }

    @Generated
    default public void devLogin(@DelegatesTo(strategy=1, value=RunDevLoginOptions.class) @ClosureParams(value=SimpleType.class, options={"net.neoforged.gradle.dsl.common.runs.run.RunDevLoginOptions"}) Closure closure) {
        closure.setDelegate((Object)this.getDevLogin());
        closure.setResolveStrategy(Integer.valueOf(1).intValue());
        closure.call((Object)this.getDevLogin());
    }

    @Generated
    default public void shouldExportToIDE(boolean shouldExportToIDE) {
        this.getShouldExportToIDE().set((Object)shouldExportToIDE);
    }

    @Generated
    default public void shouldExportToIDE() {
        this.shouldExportToIDE(DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE));
    }

    @Generated
    default public void modSources(Action<RunSourceSets> action) {
        action.execute((Object)this.getModSources());
    }

    @Generated
    default public void modSources(@DelegatesTo(strategy=1, value=RunSourceSets.class) @ClosureParams(value=SimpleType.class, options={"net.neoforged.gradle.dsl.common.runs.run.RunSourceSets"}) Closure closure) {
        closure.setDelegate((Object)this.getModSources());
        closure.setResolveStrategy(Integer.valueOf(1).intValue());
        closure.call((Object)this.getModSources());
    }

    @Generated
    default public void unitTestSources(Action<RunSourceSets> action) {
        action.execute((Object)this.getUnitTestSources());
    }

    @Generated
    default public void unitTestSources(@DelegatesTo(strategy=1, value=RunSourceSets.class) @ClosureParams(value=SimpleType.class, options={"net.neoforged.gradle.dsl.common.runs.run.RunSourceSets"}) Closure closure) {
        closure.setDelegate((Object)this.getUnitTestSources());
        closure.setResolveStrategy(Integer.valueOf(1).intValue());
        closure.call((Object)this.getUnitTestSources());
    }

    @Generated
    default public void testScope(Action<RunTestScope> action) {
        action.execute((Object)this.getTestScope());
    }

    @Generated
    default public void testScope(@DelegatesTo(strategy=1, value=RunTestScope.class) @ClosureParams(value=SimpleType.class, options={"net.neoforged.gradle.dsl.common.runs.run.RunTestScope"}) Closure closure) {
        closure.setDelegate((Object)this.getTestScope());
        closure.setResolveStrategy(Integer.valueOf(1).intValue());
        closure.call((Object)this.getTestScope());
    }

    @Generated
    default public void runtimeClasspath(Object ... paths) {
        this.getRuntimeClasspath().from(paths);
    }

    @Generated
    default public void runtimeClasspath(Object path) {
        this.getRuntimeClasspath().from(new Object[]{path});
    }

    @Generated
    default public void testRuntimeClasspath(Object ... paths) {
        this.getTestRuntimeClasspath().from(paths);
    }

    @Generated
    default public void testRuntimeClasspath(Object path) {
        this.getTestRuntimeClasspath().from(new Object[]{path});
    }

    @Generated
    default public void compileClasspath(Object ... paths) {
        this.getCompileClasspath().from(paths);
    }

    @Generated
    default public void compileClasspath(Object path) {
        this.getCompileClasspath().from(new Object[]{path});
    }

    @Generated
    default public void testCompileClasspath(Object ... paths) {
        this.getTestCompileClasspath().from(paths);
    }

    @Generated
    default public void testCompileClasspath(Object path) {
        this.getTestCompileClasspath().from(new Object[]{path});
    }

    @Generated
    default public void sdkClasspath(Object ... paths) {
        this.getSdkClasspath().from(paths);
    }

    @Generated
    default public void sdkClasspath(Object path) {
        this.getSdkClasspath().from(new Object[]{path});
    }

    @Generated
    default public void iDERunName(String iDERunName) {
        this.getIDERunName().set((Object)iDERunName);
    }

    @Generated
    default public void dependencies(Action<DependencyHandler> action) {
        action.execute((Object)this.getDependencies());
    }

    @Generated
    default public void dependencies(@DelegatesTo(strategy=1, value=DependencyHandler.class) @ClosureParams(value=SimpleType.class, options={"net.neoforged.gradle.dsl.common.runs.run.DependencyHandler"}) Closure closure) {
        closure.setDelegate((Object)this.getDependencies());
        closure.setResolveStrategy(Integer.valueOf(1).intValue());
        closure.call((Object)this.getDependencies());
    }

    @Generated
    default public void configureAutomatically(boolean configureAutomatically) {
        this.getConfigureAutomatically().set((Object)configureAutomatically);
    }

    @Generated
    default public void configureAutomatically() {
        this.configureAutomatically(DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE));
    }

    @Generated
    default public void configureFromTypeWithName(boolean configureFromTypeWithName) {
        this.getConfigureFromTypeWithName().set((Object)configureFromTypeWithName);
    }

    @Generated
    default public void configureFromTypeWithName() {
        this.configureFromTypeWithName(DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE));
    }

    @Generated
    default public void configureFromDependencies(boolean configureFromDependencies) {
        this.getConfigureFromDependencies().set((Object)configureFromDependencies);
    }

    @Generated
    default public void configureFromDependencies() {
        this.configureFromDependencies(DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE));
    }

    @Generated
    default public void dependsOn(Task val) {
        this.getDependsOn().add((Object)val);
    }

    @Generated
    default public void dependsOn(Task ... values) {
        this.getDependsOn().addAll((Object[])values);
    }

    @Generated
    default public void dependsOn(Iterable<? extends Task> values) {
        this.getDependsOn().addAll(values);
    }

    @Generated
    default public void postSyncTask(Task val) {
        this.getPostSyncTasks().add((Object)val);
    }

    @Generated
    default public void postSyncTasks(Task ... values) {
        this.getPostSyncTasks().addAll((Object[])values);
    }

    @Generated
    default public void postSyncTasks(Iterable<? extends Task> values) {
        this.getPostSyncTasks().addAll(values);
    }
}

