package net.neoforged.gradle.dsl.common.extensions.subsystems

import groovy.transform.CompileStatic
import net.neoforged.gdi.ConfigurableDSLElement
import net.neoforged.gdi.annotations.DSLProperty
import org.gradle.api.provider.ListProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.Optional

/**
 * Allows configuration of the decompiler used by NeoGradle.
 */
@CompileStatic
interface Decompiler extends ConfigurableDSLElement<Decompiler> {

    /**
     * Allows the maximum memory provided to the decompiler to be overridden. Must be specified
     * in the "123g" or "123m" form.
     */
    @Input
    @Optional
    @DSLProperty
    Property<String> getMaxMemory();

    /**
     * Allows the maximum number of threads used by the decompiler to be constrained. By default, it will
     * use all available threads.
     */
    @Input
    @Optional
    @DSLProperty
    Property<Integer> getMaxThreads();

    /**
     * The log-level to use for the decompiler. Supported values: trace, info, warn, error.
     * Defaults to {@link DecompilerLogLevel#INFO}.
     */
    @Input
    @Optional
    @DSLProperty
    Property<DecompilerLogLevel> getLogLevel();

    /**
     * Allows additional JVM arguments to be added to the decompiler invocation.
     */
    @Input
    @Optional
    @DSLProperty
    ListProperty<String> getJvmArgs();

    /**
     * Indicates whether the decompiler is enabled or not.
     * <p>
     *     When running in CI mode the decompiler will be disabled as long as no sources artifact are requested manually.
     * </p>
     *
     * @return True for disabled, false when enabled.
     */
    @Input
    @Optional
    @DSLProperty
    Property<Boolean> getIsDisabled();
}
