package net.neoforged.gradle.dsl.common.runs.idea.extensions

import groovy.transform.CompileStatic
import net.neoforged.gdi.BaseDSLElement
import net.neoforged.gdi.annotations.DSLProperty
import org.gradle.api.Project
import org.gradle.api.file.DirectoryProperty
import org.gradle.api.provider.Property

import javax.inject.Inject

@CompileStatic
abstract class IdeaRunsExtension implements BaseDSLElement<IdeaRunsExtension> {

    private final Project project;
    private final Property<Boolean> runWithIdea;
    private final Property<Boolean> useArgsFile;

    @Inject
    IdeaRunsExtension(final Project project) {
        this.project = project

        this.runWithIdea = project.getObjects().property(Boolean)
        this.useArgsFile = project.getObjects().property(Boolean)

        getRunWithIdea().convention(false)
        getUseArgsFile().convention(true)
    }

    @Override
    Project getProject() {
        return project;
    }

    @DSLProperty
    Property<Boolean> getRunWithIdea() {
        return runWithIdea;
    }

    @DSLProperty
    Property<Boolean> getUseArgsFile() {
        return useArgsFile;
    }
}